/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridSequence
extends GenericSequence {
    private CubridUser owner;
    private BigDecimal startValue;
    private BigDecimal minValue;
    private BigDecimal maxValue;
    private BigDecimal incrementBy;
    private boolean cycle;
    private int cachedNum;
    private String description;

    public CubridSequence(@NotNull GenericStructContainer container, @NotNull String name, @NotNull JDBCResultSet dbResult) {
        super(container, name, "", null, null, null, null);
        this.owner = (CubridUser)container;
        this.startValue = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"current_val");
        this.minValue = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"min_val");
        this.maxValue = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"max_val");
        this.incrementBy = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"increment_val");
        this.cycle = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"cyclic");
        this.cachedNum = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"cached_num");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
    }

    public CubridSequence(@NotNull GenericStructContainer container, @NotNull String name) {
        super(container, name);
        this.owner = (CubridUser)container;
        this.startValue = new BigDecimal(1);
        this.minValue = new BigDecimal(1);
        this.maxValue = new BigDecimal(Long.MAX_VALUE);
        this.incrementBy = new BigDecimal(1);
        this.cycle = false;
        this.cachedNum = 0;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=2)
    @NotNull
    public CubridUser getOwner() {
        return this.owner;
    }

    @Property(hidden=true)
    public Number getLastValue() {
        return null;
    }

    @Property(viewable=true, editable=true, updatable=true, order=3)
    @NotNull
    public BigDecimal getStartValue() {
        return this.startValue;
    }

    public void setStartValue(@NotNull BigDecimal startValue) {
        this.startValue = startValue;
    }

    @Property(viewable=true, editable=true, updatable=true, order=4)
    @NotNull
    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(@NotNull BigDecimal minValue) {
        this.minValue = minValue;
    }

    @Property(viewable=true, editable=true, updatable=true, order=5)
    @NotNull
    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(@NotNull BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    @Property(viewable=true, editable=true, updatable=true, order=6)
    @NotNull
    public BigDecimal getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(@NotNull BigDecimal incrementBy) {
        this.incrementBy = incrementBy;
    }

    @Property(viewable=true, editable=true, updatable=true, order=7)
    @NotNull
    public boolean getCycle() {
        return this.cycle;
    }

    public void setCycle(@NotNull boolean cycle) {
        this.cycle = cycle;
    }

    @Property(viewable=true, editable=true, updatable=true, order=8)
    @NotNull
    public int getCachedNum() {
        return this.cachedNum;
    }

    public void setCachedNum(@NotNull int cachedNum) {
        this.cachedNum = cachedNum;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        if (this.owner.getDataSource().getSupportMultiSchema()) {
            return DBUtils.getQuotedIdentifier((DBSObject)this.getOwner()) + "." + DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
        }
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
    }
}

