/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ConfigurationInfo;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationMessages;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFolder;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.MessageBoxBuilder;
import org.jkiss.dbeaver.ui.dialogs.Reply;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class CollectDiagnosticInfoHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(CollectDiagnosticInfoHandler.class);

    @Nullable
    public Object execute(ExecutionEvent event) throws ExecutionException {
        CollectDiagnosticInfoDialog dialog = new CollectDiagnosticInfoDialog(event);
        int returnCode = dialog.open();
        if (returnCode != 0) {
            log.trace((Object)"User cancelled %s".formatted(CollectDiagnosticInfoDialog.class.getName()));
            return null;
        }
        File archive = new File(dialog.getOutputFolder(), "dbeaver-diagnostic-info-%d.zip".formatted(System.currentTimeMillis()));
        if (archive.exists()) {
            log.warn((Object)"File %s already exists".formatted(archive));
            CollectDiagnosticInfoHandler.showError();
            return null;
        }
        log.trace((Object)"Writing diagnostic info archive");
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(archive));){
            for (File file : CollectDiagnosticInfoHandler.getLogFiles()) {
                out.putNextEntry(new ZipEntry(file.getName()));
                try (FileInputStream in = new FileInputStream(file);){
                    in.transferTo(out);
                }
                out.closeEntry();
            }
            out.putNextEntry(new ZipEntry("configuration.txt"));
            out.write(ConfigurationInfo.getSystemSummary().getBytes(StandardCharsets.UTF_8));
            out.closeEntry();
        }
        catch (IOException e) {
            log.warn((Object)"Cannot collect diagnostic data into archive '%s': caught exception".formatted(archive), (Throwable)e);
            CollectDiagnosticInfoHandler.showError();
        }
        UIUtils.asyncExec(() -> ShellUtils.showInSystemExplorer((File)archive));
        return null;
    }

    private static void showError() {
        UIUtils.syncExec(() -> MessageBoxBuilder.builder((Shell)UIUtils.getActiveWorkbenchShell()).setTitle(CoreApplicationMessages.collect_diagnostic_info_error_message_title).setMessage(CoreApplicationMessages.collect_diagnostic_info_error_message_text).setReplies(new Reply[]{Reply.CLOSE}).setDefaultReply(Reply.CLOSE).setPrimaryImage((DBPImage)DBIcon.STATUS_ERROR).setCustomArea(parent -> CollectDiagnosticInfoHandler.createDocumentationLink(parent, CoreApplicationMessages.collect_diagnostic_info_error_message_hint)).showMessageBox());
    }

    @NotNull
    private static Iterable<File> getLogFiles() {
        String logFileNameExtension;
        String logFileName;
        File logFileLocation;
        ArrayList<File> logs = new ArrayList<File>();
        logs.add(Platform.getLogFileLocation().toFile());
        File debugLogFile = CollectDiagnosticInfoHandler.getCurrentDebugLogFile();
        if (debugLogFile.exists() && debugLogFile.isFile()) {
            logs.add(debugLogFile);
        }
        if ((logFileLocation = debugLogFile.getParentFile()) == null || !logFileLocation.isDirectory()) {
            return logs;
        }
        String fileName = debugLogFile.getName();
        int fnameExtStart = fileName.lastIndexOf(46);
        if (fnameExtStart >= 0) {
            logFileName = fileName.substring(0, fnameExtStart);
            logFileNameExtension = fileName.substring(fnameExtStart);
        } else {
            logFileName = fileName;
            logFileNameExtension = "";
        }
        String logFileNameRegexStr = "^" + Pattern.quote(logFileName) + "\\-[0-9]+" + Pattern.quote(logFileNameExtension) + "$";
        Predicate<String> logFileNamePattern = Pattern.compile(logFileNameRegexStr).asMatchPredicate();
        File[] debugLogFiles = logFileLocation.listFiles((dir, name) -> logFileNamePattern.test(name));
        if (debugLogFiles != null) {
            Collections.addAll(logs, debugLogFiles);
        }
        return logs;
    }

    @NotNull
    private static File getCurrentDebugLogFile() {
        String logLocation = DBWorkbench.getPlatform().getPreferenceStore().getString("logs.debug.location");
        if (CommonUtils.isEmpty((String)logLocation)) {
            logLocation = GeneralUtils.getMetadataFolder().resolve("dbeaver-debug.log").toAbsolutePath().toString();
        }
        logLocation = GeneralUtils.replaceVariables((String)logLocation, (IVariableResolver)new SystemVariablesResolver());
        return new File(logLocation);
    }

    private static void createDocumentationLink(@NotNull Composite parent, @NotNull String text) {
        String linkToDocs = HelpUtils.getHelpExternalReference((String)"Log-files");
        String href = "<a href=\"" + linkToDocs + "\">" + text + "</a>";
        UIUtils.createInfoLink((Composite)parent, (String)href, () -> ShellUtils.launchProgram((String)linkToDocs));
    }

    private static final class CollectDiagnosticInfoDialog
    extends BaseDialog {
        @Nullable
        private TextWithOpen textWithOpen;
        @Nullable
        private File outputFolder;

        private CollectDiagnosticInfoDialog(ExecutionEvent event) {
            super(HandlerUtil.getActiveShell((ExecutionEvent)event), CoreApplicationMessages.collect_diagnostic_info_pick_path_title, null);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite dialogArea = super.createDialogArea(parent);
            dialogArea = UIUtils.createComposite((Composite)dialogArea, (int)1);
            dialogArea.setLayoutData((Object)new GridData(1808));
            Composite outputFolderPickerComposite = UIUtils.createComposite((Composite)dialogArea, (int)2);
            outputFolderPickerComposite.setLayoutData((Object)new GridData(1808));
            UIUtils.createControlLabel((Composite)outputFolderPickerComposite, (String)CoreApplicationMessages.collect_diagnostic_info_pick_path_label);
            this.textWithOpen = new TextWithOpenFolder(outputFolderPickerComposite, CoreApplicationMessages.collect_diagnostic_info_pick_path_title);
            this.textWithOpen.setLayoutData((Object)new GridData(768));
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                this.textWithOpen.setText(userHome);
            } else {
                this.enableOk(false);
            }
            Text textControl = this.textWithOpen.getTextControl();
            textControl.addModifyListener(event -> {
                File file = new File(textControl.getText());
                this.enableOk(file.isDirectory());
            });
            UIUtils.createWarningLabel((Composite)dialogArea, (String)CoreApplicationMessages.collect_diagnostic_info_pick_path_warning, (int)768, (int)1);
            return dialogArea;
        }

        private void enableOk(boolean enable) {
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setEnabled(enable);
            }
        }

        protected void okPressed() {
            String outputFolderPathString;
            if (this.textWithOpen != null && !CommonUtils.isEmpty((String)(outputFolderPathString = this.textWithOpen.getText()))) {
                this.outputFolder = new File(outputFolderPathString);
            }
            super.okPressed();
        }

        @Nullable
        private File getOutputFolder() {
            return this.outputFolder;
        }
    }
}

