/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.completion;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBInfoUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.sql.SQLHelpProvider;
import org.jkiss.dbeaver.model.sql.SQLHelpTopic;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionContext;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SQLCompletionHelper {
    private static final Log log = Log.getLog(SQLCompletionHelper.class);
    public static final int ADDITIONAL_INFO_WAIT_TIMEOUT = 3000;

    @Nullable
    public static String readAdditionalProposalInfo(@Nullable DBRProgressMonitor monitor, @NotNull SQLCompletionContext context, @Nullable DBPNamedObject object, String[] keywords, @Nullable DBPKeywordType keywordType) {
        if (object != null) {
            if (monitor == null) {
                String[] desc = new String[1];
                RuntimeUtils.runTask(monitor1 -> {
                    desc[0] = DBInfoUtils.makeObjectDescription((DBRProgressMonitor)monitor1, (DBPNamedObject)object, (boolean)true);
                }, (String)"Extract object properties info", (long)3000L);
                return desc[0];
            }
            return DBInfoUtils.makeObjectDescription((DBRProgressMonitor)monitor, (DBPNamedObject)object, (boolean)true);
        }
        if (keywordType != null && context.getDataSource() != null && context.isShowServerHelp()) {
            HelpReader helpReader = new HelpReader(context.getDataSource(), keywordType, keywords);
            if (monitor == null) {
                RuntimeUtils.runTask((DBRRunnableWithProgress)helpReader, (String)"Read help topic", (long)3000L);
            } else {
                helpReader.run(monitor);
            }
            return helpReader.info;
        }
        return keywords.length == 0 ? null : keywords[0];
    }

    private static String readDataSourceHelp(DBRProgressMonitor monitor, DBPDataSource dataSource, DBPKeywordType keywordType, String keyword) {
        SQLHelpProvider helpProvider = (SQLHelpProvider)DBUtils.getAdapter(SQLHelpProvider.class, (Object)dataSource);
        if (helpProvider == null) {
            return null;
        }
        SQLHelpTopic helpTopic = helpProvider.findHelpTopic(monitor, keyword, keywordType);
        if (helpTopic == null) {
            return null;
        }
        if (!CommonUtils.isEmpty((String)helpTopic.getContents())) {
            return helpTopic.getContents();
        }
        if (!CommonUtils.isEmpty((String)helpTopic.getUrl())) {
            return "<a href=\"" + helpTopic.getUrl() + "\">" + keyword + "</a>";
        }
        return null;
    }

    private static class HelpReader
    implements DBRRunnableWithProgress {
        private final DBPDataSource dataSource;
        private final DBPKeywordType keywordType;
        private final String[] keywords;
        private String info;

        public HelpReader(DBPDataSource dataSource, DBPKeywordType keywordType, String[] keywords) {
            this.dataSource = dataSource;
            this.keywordType = keywordType;
            this.keywords = keywords;
        }

        public void run(DBRProgressMonitor monitor) {
            for (String keyword : this.keywords) {
                this.info = SQLCompletionHelper.readDataSourceHelp(monitor, this.dataSource, this.keywordType, keyword);
                if (this.info != null) break;
            }
            if (CommonUtils.isEmpty((String)this.info)) {
                this.info = "<b>" + this.keywords[0] + "</b> (" + this.keywordType.name() + ")";
            }
        }
    }
}

