/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.content;

import java.util.Objects;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.TextController;
import org.freeplane.plugin.ai.tools.content.NodeContentPreset;
import org.freeplane.plugin.ai.tools.content.NodeContentValueMatcher;
import org.freeplane.plugin.ai.tools.content.TextualContent;
import org.freeplane.plugin.ai.tools.content.TextualContentRequest;

public class TextualContentReader {
    private final TextController textController;

    public TextualContentReader(TextController textController) {
        this.textController = Objects.requireNonNull(textController, "textController");
    }

    public String readBriefText(NodeModel nodeModel) {
        if (nodeModel == null) {
            return null;
        }
        return this.textController.getShortPlainText(nodeModel);
    }

    public TextualContent readTextualContent(NodeModel nodeModel, NodeContentPreset preset) {
        if (nodeModel == null) {
            return null;
        }
        if (preset == NodeContentPreset.BRIEF) {
            return null;
        }
        String text = this.readFullText(nodeModel);
        String details = this.readFullDetails(nodeModel);
        String note = this.readFullNote(nodeModel);
        if (text == null && details == null && note == null) {
            return null;
        }
        return new TextualContent(text, details, note);
    }

    public TextualContent readTextualContent(NodeModel nodeModel, TextualContentRequest request) {
        String note;
        if (nodeModel == null || request == null) {
            return null;
        }
        String text = request.includesText() ? this.readFullText(nodeModel) : null;
        String details = request.includesDetails() ? this.readFullDetails(nodeModel) : null;
        String string = note = request.includesNote() ? this.readFullNote(nodeModel) : null;
        if (text == null && details == null && note == null) {
            return null;
        }
        return new TextualContent(text, details, note);
    }

    public boolean matches(NodeModel nodeModel, TextualContentRequest request, NodeContentValueMatcher valueMatcher) {
        if (nodeModel == null || request == null || valueMatcher == null) {
            return false;
        }
        if (request.includesText() && valueMatcher.matchesValue(this.readFullText(nodeModel))) {
            return true;
        }
        if (request.includesDetails() && valueMatcher.matchesValue(this.readFullDetails(nodeModel))) {
            return true;
        }
        return request.includesNote() && valueMatcher.matchesValue(this.readFullNote(nodeModel));
    }

    private String readFullText(NodeModel nodeModel) {
        Object data = nodeModel.getUserObject();
        if (data == null) {
            return null;
        }
        String transformedText = this.textController.getTransformedTextForClipboard(nodeModel, (Object)nodeModel, data);
        return this.convertToPlainText(transformedText);
    }

    private String readFullDetails(NodeModel nodeModel) {
        DetailModel detailModel = DetailModel.getDetail((NodeModel)nodeModel);
        if (detailModel == null) {
            return null;
        }
        String detailsText = detailModel.getText();
        if (detailsText == null) {
            return null;
        }
        String transformedText = this.textController.getTransformedTextForClipboard(nodeModel, (Object)detailModel, (Object)detailsText);
        return this.convertToPlainText(transformedText);
    }

    private String readFullNote(NodeModel nodeModel) {
        NoteModel noteModel = NoteModel.getNote((NodeModel)nodeModel);
        if (noteModel == null) {
            return null;
        }
        String noteText = noteModel.getText();
        if (noteText == null) {
            return null;
        }
        String transformedText = this.textController.getTransformedTextForClipboard(nodeModel, (Object)noteModel, (Object)noteText);
        return this.convertToPlainText(transformedText);
    }

    private String convertToPlainText(String text) {
        if (text == null) {
            return null;
        }
        return HtmlUtils.htmlToPlain((String)text);
    }
}

