/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.AddressesReadPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddressesReadTracePcodeExecutorStatePiece
extends AbstractLongOffsetPcodeExecutorStatePiece<byte[], AddressSetView, AddressSpace>
implements PcodeExecutorStatePiece<byte[], AddressSetView> {
    protected final PcodeTraceDataAccess data;
    private final Map<Long, AddressSetView> unique;

    protected AddressesReadTracePcodeExecutorStatePiece(PcodeTraceDataAccess data, Map<Long, AddressSetView> unique) {
        super(data.getLanguage(), (PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)data.getLanguage()), (PcodeArithmetic)AddressesReadPcodeArithmetic.INSTANCE, PcodeStateCallbacks.NONE);
        this.data = data;
        this.unique = unique;
    }

    public AddressesReadTracePcodeExecutorStatePiece(PcodeTraceDataAccess data) {
        this(data, new HashMap<Long, AddressSetView>());
    }

    protected AddressSetView checkSize(int size, AddressSetView val) {
        return val;
    }

    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        throw new ConcretionError("Cannot make 'addresses read' concrete buffers", purpose);
    }

    public AddressesReadTracePcodeExecutorStatePiece fork(PcodeStateCallbacks cb) {
        return new AddressesReadTracePcodeExecutorStatePiece(this.data, new HashMap<Long, AddressSetView>(this.unique));
    }

    protected Map<Register, AddressSetView> getRegisterValuesFromSpace(AddressSpace s, List<Register> registers) {
        return Map.of();
    }

    public Map<Register, AddressSetView> getRegisterValues() {
        return Map.of();
    }

    protected AddressSpace getForSpace(AddressSpace space, boolean toWrite) {
        return space;
    }

    protected void setInSpace(AddressSpace space, long offset, int size, AddressSetView val, PcodeStateCallbacks cb) {
        if (!space.isUniqueSpace()) {
            return;
        }
        this.unique.put(offset, val);
    }

    protected AddressSetView getFromSpace(AddressSpace space, long offset, int size, PcodeExecutorStatePiece.Reason reason, PcodeStateCallbacks cb) {
        if (space.isUniqueSpace()) {
            AddressSetView result = this.unique.get(offset);
            if (result == null) {
                return new AddressSet();
            }
            return result;
        }
        Address start = this.data.translate(space.getAddress(offset));
        if (start == null) {
            return null;
        }
        try {
            return new AddressSet((AddressRange)new AddressRangeImpl(start, (long)size));
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void clear() {
        this.unique.clear();
    }
}

