/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import generic.theme.GIcon;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.component.margin.DecompilerMarginProvider;
import ghidra.app.decompiler.component.margin.LayoutPixelIndexMap;
import ghidra.app.plugin.core.decompiler.taint.TaintLabel;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.program.model.listing.Program;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;

public class TaintDecompilerMarginProvider
extends JPanel
implements DecompilerMarginProvider,
LayoutModelListener {
    private LayoutModel model;
    private LayoutPixelIndexMap pixmap;
    private final TaintPlugin plugin;
    private Set<String> sourceAddresses = new HashSet<String>();
    private Set<String> sinkAddresses = new HashSet<String>();
    private Set<String> gateAddresses = new HashSet<String>();
    private Icon sourceIcon = new GIcon("icon.plugin.scriptmanager.run");
    private Icon sinkIcon = new GIcon("icon.stop");
    private Icon gateIcon = new GIcon("icon.plugin.decompiler.taint.gate.set");

    public TaintDecompilerMarginProvider(TaintPlugin plugin) {
        this.plugin = plugin;
        this.setPreferredSize(new Dimension(16, 0));
    }

    public void setProgram(Program program, LayoutModel model, LayoutPixelIndexMap pixmap) {
        this.setLayoutManager(model);
        this.pixmap = pixmap;
        this.repaint();
    }

    public void functionChanged() {
        this.repaint();
    }

    private void setLayoutManager(LayoutModel model) {
        if (this.model == model) {
            return;
        }
        if (this.model != null) {
            this.model.removeLayoutModelListener((LayoutModelListener)this);
        }
        this.model = model;
        if (this.model != null) {
            this.model.addLayoutModelListener((LayoutModelListener)this);
        }
    }

    public Component getComponent() {
        return this;
    }

    public void modelSizeChanged(IndexMapper indexMapper) {
        this.repaint();
    }

    public void dataChanged(BigInteger start, BigInteger end) {
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.plugin.getDecompilerProvider() == null) {
            return;
        }
        Rectangle visible = this.getVisibleRect();
        BigInteger startIdx = this.pixmap.getIndex(visible.y);
        BigInteger endIdx = this.pixmap.getIndex(visible.y + visible.height);
        List lines = this.plugin.getDecompilerProvider().getDecompilerPanel().getLines();
        BigInteger index = startIdx;
        while (index.compareTo(endIdx) <= 0) {
            int i = index.intValue();
            if (i < lines.size()) {
                ClangLine line = (ClangLine)lines.get(i);
                if (this.sourceAddresses.contains(line.toString())) {
                    this.sourceIcon.paintIcon(this, g, 0, this.pixmap.getPixel(index));
                }
                if (this.sinkAddresses.contains(line.toString())) {
                    this.sinkIcon.paintIcon(this, g, 0, this.pixmap.getPixel(index));
                }
                if (this.gateAddresses.contains(line.toString())) {
                    this.gateIcon.paintIcon(this, g, 0, this.pixmap.getPixel(index));
                }
            }
            index = index.add(BigInteger.ONE);
        }
    }

    public void toggleIcon(TaintLabel label) {
        Set<String> addresses;
        switch (label.getType()) {
            case SOURCE: {
                Set<String> set = this.sourceAddresses;
                break;
            }
            case SINK: {
                Set<String> set = this.sinkAddresses;
                break;
            }
            case GATE: {
                Set<String> set = this.gateAddresses;
                break;
            }
            default: {
                Set<String> set = addresses = null;
            }
        }
        if (addresses != null) {
            String cline = label.getClangLine().toString();
            if (label.isActive()) {
                addresses.add(cline);
            } else {
                addresses.remove(cline);
            }
            this.repaint();
        }
    }

    public void clearIcons() {
        this.sourceAddresses.clear();
        this.sinkAddresses.clear();
        this.gateAddresses.clear();
    }
}

