/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.events;

import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.ToolEventName;
import ghidra.program.model.listing.Program;
import java.lang.ref.WeakReference;

@ToolEventName(value="Open/Close Program")
public class ProgramVisibilityChangePluginEvent
extends PluginEvent {
    static final String NAME = "Open Program";
    static final String TOOL_EVENT_NAME = "Open/Close Program";
    private WeakReference<Program> programRef;
    private boolean isVisible;

    public ProgramVisibilityChangePluginEvent(String source, Program p, boolean isVisible) {
        super(source, NAME);
        this.isVisible = isVisible;
        this.programRef = new WeakReference<Program>(p);
    }

    public Program getProgram() {
        return (Program)this.programRef.get();
    }

    public boolean isProgramVisible() {
        return this.isVisible;
    }
}

