/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.widgets.button.GButton;
import generic.theme.GIcon;
import ghidra.app.plugin.core.function.tags.SourceTagsPanel;
import ghidra.app.plugin.core.function.tags.TargetTagsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import resources.Icons;

public class FunctionTagButtonPanel
extends JPanel {
    private SourceTagsPanel sourcePanel;
    private TargetTagsPanel targetPanel;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton deleteBtn;

    public FunctionTagButtonPanel(SourceTagsPanel sourcePanel, TargetTagsPanel targetPanel) {
        this.sourcePanel = sourcePanel;
        this.targetPanel = targetPanel;
        this.createButtonPanel();
    }

    public void sourcePanelSelectionChanged(boolean validFunction) {
        boolean hasSelection = this.sourcePanel.hasSelection();
        boolean isImmutable = this.sourcePanel.isSelectionImmutable();
        boolean isEnabled = this.sourcePanel.isSelectionEnabled();
        this.addBtn.setEnabled(hasSelection && validFunction && isEnabled);
        this.removeBtn.setEnabled(false);
        if (!hasSelection) {
            this.sourcePanel.clearSelection();
        }
        this.deleteBtn.setEnabled(hasSelection && !isImmutable);
    }

    public void targetPanelSelectionChanged(boolean validFunction) {
        boolean hasSelection = this.targetPanel.hasSelection();
        boolean isImmutable = this.targetPanel.isSelectionImmutable();
        this.removeBtn.setEnabled(hasSelection && validFunction);
        this.addBtn.setEnabled(false);
        if (!hasSelection) {
            this.targetPanel.clearSelection();
        }
        this.deleteBtn.setEnabled(hasSelection && !isImmutable);
    }

    private void createButtonPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.addBtn = this.createButton("addBtn", (Icon)new GIcon("icon.plugin.functiontags.add"), "Add selected tags to the function", e -> this.sourcePanel.addSelectedTags());
        this.add((Component)this.addBtn, gbc);
        gbc.gridy = 1;
        this.removeBtn = this.createButton("removeBtn", (Icon)new GIcon("icon.plugin.functiontags.remove"), "Remove selected tags from the function", e -> this.targetPanel.removeSelectedTags());
        this.add((Component)this.removeBtn, gbc);
        gbc.gridy = 2;
        this.deleteBtn = this.createButton("deleteBtn", Icons.DELETE_ICON, "Deletes the selected tags from the program", e -> {
            this.sourcePanel.deleteSelectedTags();
            this.targetPanel.deleteSelectedTags();
        });
        this.add((Component)this.deleteBtn, gbc);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setMaximumSize(new Dimension(30, 300));
        this.addBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.deleteBtn.setEnabled(false);
    }

    private JButton createButton(String name, Icon icon, String tooltip, ActionListener action) {
        GButton button = new GButton(name);
        button.setName(name);
        button.setToolTipText(tooltip);
        button.setIcon(icon);
        button.setText("");
        button.addActionListener(action);
        return button;
    }
}

