/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;

public enum RebaseOpcode {
    REBASE_OPCODE_DONE(0),
    REBASE_OPCODE_SET_TYPE_IMM(16),
    REBASE_OPCODE_SET_SEGMENT_AND_OFFSET_ULEB(32),
    REBASE_OPCODE_ADD_ADDR_ULEB(48),
    REBASE_OPCODE_ADD_ADDR_IMM_SCALED(64),
    REBASE_OPCODE_DO_REBASE_IMM_TIMES(80),
    REBASE_OPCODE_DO_REBASE_ULEB_TIMES(96),
    REBASE_OPCODE_DO_REBASE_ADD_ADDR_ULEB(112),
    REBASE_OPCODE_DO_REBASE_ULEB_TIMES_SKIPPING_ULEB(128);

    private int opcode;

    private RebaseOpcode(int opcode) {
        this.opcode = opcode;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public static DataType toDataType() {
        EnumDataType enumDataType = new EnumDataType("rebase_opcode", 1);
        enumDataType.setCategoryPath(new CategoryPath("/MachO"));
        for (RebaseOpcode rebaseOpcode : RebaseOpcode.values()) {
            enumDataType.add(rebaseOpcode.toString(), (long)rebaseOpcode.getOpcode());
        }
        return enumDataType;
    }

    public static RebaseOpcode forOpcode(int opcode) {
        for (RebaseOpcode rebaseOpcode : RebaseOpcode.values()) {
            if (rebaseOpcode.getOpcode() != opcode) continue;
            return rebaseOpcode;
        }
        return null;
    }
}

