/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.hyper;

import ghidra.util.database.spatial.hyper.Dimension;
import ghidra.util.database.spatial.hyper.HyperBox;
import ghidra.util.database.spatial.hyper.HyperPoint;
import java.math.BigInteger;
import java.util.Objects;

public interface StringDimension<P extends HyperPoint, B extends HyperBox<P, B>>
extends Dimension<String, P, B> {
    @Override
    default public int compare(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        return a.compareTo(b);
    }

    public static int charAt(String s, int i) {
        if (s == null) {
            if (i == 0) {
                return 128;
            }
            return 0;
        }
        if (i < s.length()) {
            return Math.min(127, s.charAt(i));
        }
        return 0;
    }

    public static int lenStrings(String a, String b) {
        if (a == null) {
            return b.length();
        }
        if (b == null) {
            return a.length();
        }
        return Math.max(a.length(), b.length());
    }

    @Override
    default public double distance(String a, String b) {
        if (Objects.equals(a, b)) {
            return 0.0;
        }
        double result = 0.0;
        double placeVal = 1.4044477616111841E306;
        int len = StringDimension.lenStrings(a, b);
        for (int i = 0; i < len; ++i) {
            int ca = StringDimension.charAt(a, i);
            double oldResult = result;
            int cb = StringDimension.charAt(b, i);
            if (oldResult == (result += placeVal * (double)(cb - ca))) {
                return result;
            }
            if (placeVal == Double.MIN_VALUE || placeVal == 0.0) {
                return result;
            }
            placeVal /= 128.0;
        }
        return result;
    }

    public static BigInteger subtractExact(String a, String b) {
        int len = StringDimension.lenStrings(a, b);
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < len; ++i) {
            int ca = StringDimension.charAt(a, i);
            int cb = StringDimension.charAt(b, i);
            result = result.shiftLeft(7).add(BigInteger.valueOf(ca - cb));
        }
        return result;
    }

    public static String add(String a, BigInteger d, int len) {
        char[] cb = new char[len];
        boolean carry = false;
        for (int i = len - 1; i >= 0; --i) {
            int tc = StringDimension.charAt(a, i) + d.intValue() % 128 + (carry ? 1 : 0);
            d = d.shiftRight(7);
            carry = tc >= 128;
            cb[i] = (char)(tc % 128);
        }
        return new String(cb);
    }

    @Override
    default public String mid(String a, String b) {
        if (Objects.equals(a, b)) {
            return a;
        }
        if (a == null && b.isEmpty()) {
            return "@";
        }
        if (b == null && a.isEmpty()) {
            return "@";
        }
        if (a.compareTo(b) > 0) {
            String c = a;
            a = b;
            b = c;
        }
        BigInteger diff = StringDimension.subtractExact(b, a);
        String maybeTrunc = StringDimension.add(a, diff.shiftRight(1), StringDimension.lenStrings(a, b));
        if (diff.testBit(0)) {
            return maybeTrunc + "@";
        }
        return maybeTrunc;
    }

    @Override
    default public String absoluteMin() {
        return "";
    }

    @Override
    default public String absoluteMax() {
        return null;
    }
}

