/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.DropTargetFactory;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.util.FileOpenDropHandler;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.PluginsConfiguration;
import ghidra.framework.project.tool.ExtensionManager;
import ghidra.framework.project.tool.GhidraPluginsConfiguration;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.framework.project.tool.OpenFileDropHandlerFactory;
import ghidra.util.HelpLocation;
import java.awt.Component;
import org.jdom.Element;

public class GhidraTool
extends PluginTool {
    private static final String NON_AUTOSAVE_SAVE_TOOL_TITLE = "Save Tool?";
    public static boolean autoSave = true;
    private FileOpenDropHandler fileOpenDropHandler;
    private DockingAction configureToolAction;
    private ExtensionManager extensionManager;
    private boolean hasBeenShown;

    public GhidraTool(Project project, String name) {
        super(project, name, true, true, false);
    }

    public GhidraTool(Project project, GhidraToolTemplate template) {
        super(project, template);
    }

    private ExtensionManager getExtensionManager() {
        if (this.extensionManager == null) {
            this.extensionManager = new ExtensionManager(this);
        }
        return this.extensionManager;
    }

    @Override
    protected DockingWindowManager createDockingWindowManager(boolean isDockable, boolean hasStatus, boolean isModal) {
        return new DockingWindowManager((Tool)this, null, isModal, isDockable, hasStatus, (DropTargetFactory)new OpenFileDropHandlerFactory(this));
    }

    @Override
    protected void initActions() {
        this.addSaveToolAction();
        this.addExportToolAction();
        this.addCloseAction();
        this.addExitAction();
        this.addManagePluginsAction();
        this.addOptionsAction();
        this.addHelpActions();
        this.addNextPreviousProviderActions();
    }

    @Override
    protected PluginsConfiguration createPluginsConfigurations() {
        return new GhidraPluginsConfiguration();
    }

    @Override
    public void setToolName(String name) {
        super.setToolName(name);
        this.setConfigChanged(true);
    }

    @Override
    public ToolTemplate getToolTemplate(boolean includeConfigState) {
        return new GhidraToolTemplate(this.iconURL, this.saveToXml(includeConfigState), this.getSupportedDataTypes());
    }

    @Override
    public Element saveWindowingDataToXml() {
        return this.winMgr.saveWindowingDataToXml();
    }

    @Override
    public void restoreWindowingDataFromXml(Element rootElement) {
        this.winMgr.restoreWindowDataFromXml(rootElement);
    }

    @Override
    public Element saveToXml(boolean includeConfigState) {
        Element xml = super.saveToXml(includeConfigState);
        this.getExtensionManager().saveToXml(xml);
        return xml;
    }

    @Override
    protected boolean restoreFromXml(Element root) {
        boolean success = super.restoreFromXml(root);
        this.getExtensionManager().restoreFromXml(root);
        return success;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (!this.hasBeenShown) {
                this.getExtensionManager().checkForNewExtensions();
            }
            this.hasBeenShown = true;
        }
        super.setVisible(visible);
    }

    @Override
    public boolean shouldSave() {
        if (autoSave) {
            return true;
        }
        if (this.hasConfigChanged()) {
            return this.promptUserToSave();
        }
        return false;
    }

    @Override
    protected boolean doSaveTool() {
        if (autoSave) {
            return super.doSaveTool();
        }
        if (this.hasConfigChanged() && this.promptUserToSave()) {
            this.saveTool();
        }
        return true;
    }

    private boolean promptUserToSave() {
        int result = OptionDialog.showOptionNoCancelDialog((Component)this.getToolFrame(), (String)NON_AUTOSAVE_SAVE_TOOL_TITLE, (String)("The tool configuration has changed for " + this.getName() + ".\nDo you want to save it to your tool chest?"), (String)"&Save", (String)"Do&n't Save", (int)3);
        return result == 1;
    }

    @Override
    public void dispose() {
        if (this.fileOpenDropHandler != null) {
            this.fileOpenDropHandler.dispose();
            this.fileOpenDropHandler = null;
        }
        super.dispose();
    }

    private void addCloseAction() {
        DockingAction closeAction = new DockingAction("Close Tool", "Tool"){

            public void actionPerformed(ActionContext context) {
                GhidraTool.this.close();
            }
        };
        closeAction.setHelpLocation(new HelpLocation("Tool", closeAction.getName()));
        closeAction.setEnabled(true);
        closeAction.setMenuBarData(new MenuData(new String[]{"&File", "Close Tool"}, null, "Window_A"));
        this.addAction((DockingActionIf)closeAction);
    }

    protected void addManagePluginsAction() {
        this.configureToolAction = new DockingAction("Configure Tool", "Tool"){

            public void actionPerformed(ActionContext context) {
                GhidraTool.this.showConfig();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return GhidraTool.this.isConfigurable();
            }
        };
        this.configureToolAction.setMenuBarData(new MenuData(new String[]{"&File", "Configure"}, null, "PrintPost_PreTool"));
        this.configureToolAction.setEnabled(true);
        this.addAction((DockingActionIf)this.configureToolAction);
    }

    protected void showConfig() {
        this.showConfig(true, false);
    }
}

