/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization.mouse;

import ghidra.graph.visualization.mouse.AbstractJgtGraphMousePlugin;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.transform.MutableTransformer;

public class JgtTranslatingPlugin<V, E>
extends AbstractJgtGraphMousePlugin<V, E> {
    private boolean panning;
    private boolean isHandlingEvent;
    private int translatingMask;

    public JgtTranslatingPlugin() {
        this(1024);
    }

    public JgtTranslatingPlugin(int modifiers) {
        this.translatingMask = modifiers;
        this.cursor = Cursor.getPredefinedCursor(13);
    }

    public boolean checkModifiers(MouseEvent e) {
        return e.getModifiersEx() == this.translatingMask;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean accepted;
        boolean bl = accepted = this.checkModifiers(e) && this.isInDraggingArea(e);
        if (!accepted) {
            return;
        }
        this.down = e.getPoint();
        VisualizationViewer viewer = this.getGraphViewer(e);
        viewer.setCursor(this.cursor);
        this.isHandlingEvent = true;
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean wasHandlingEvent = this.isHandlingEvent;
        this.isHandlingEvent = false;
        this.down = null;
        this.installCursor(Cursor.getPredefinedCursor(0), e);
        if (wasHandlingEvent && this.panning) {
            e.consume();
        }
        this.panning = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean accepted = this.checkModifiers(e);
        if (!accepted) {
            return;
        }
        if (!this.isHandlingEvent) {
            return;
        }
        this.panning = true;
        VisualizationViewer viewer = this.getGraphViewer(e);
        RenderContext context = viewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = context.getMultiLayerTransformer();
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        viewer.setCursor(this.cursor);
        Point2D downPoint = multiLayerTransformer.inverseTransform((Point2D)this.down);
        Point2D p = multiLayerTransformer.inverseTransform((Point2D)e.getPoint());
        float dx = (float)(p.getX() - downPoint.getX());
        float dy = (float)(p.getY() - downPoint.getY());
        layoutTransformer.translate((double)dx, (double)dy);
        this.down.x = e.getX();
        this.down.y = e.getY();
        e.consume();
        viewer.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isHandlingEvent) {
            return;
        }
        if (!this.isInDraggingArea(e)) {
            return;
        }
        if (!this.checkModifiersForCursor(e)) {
            return;
        }
        this.installCursor(this.cursor, e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.installCursor(Cursor.getPredefinedCursor(0), e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.checkModifiersForCursor(e)) {
            return;
        }
        if (this.isHandlingEvent) {
            e.consume();
        }
        if (this.isInDraggingArea(e)) {
            this.installCursor(this.cursor, e);
            e.consume();
        }
    }

    private boolean checkModifiersForCursor(MouseEvent e) {
        return e.getModifiersEx() == 0;
    }

    private boolean isInDraggingArea(MouseEvent e) {
        return !this.isOverVertex(e) && !this.isOverEdge(e);
    }

    @Override
    public void installCursor(Cursor newCursor, MouseEvent e) {
        VisualizationViewer viewer = this.getViewer(e);
        viewer.setCursor(newCursor);
    }
}

