/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.testcode.editgpt;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.catacombae.csjc.structelements.Array;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.StringRepresentableField;
import org.catacombae.csjc.structelements.StructElement;
import org.catacombae.hfsexplorer.testcode.editgpt.EditStringValuePanel;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerPanel
extends JPanel {
    private LinkedList<ContainerPanel> subPanels = new LinkedList();
    private LinkedList<EditStringValuePanel> fields = new LinkedList();
    private JPanel contentsPanel;
    private JLabel descriptionLabel;
    private JButton saveButton;

    public ContainerPanel() {
        this((String)null);
    }

    public ContainerPanel(String label) {
        this.initComponents();
        if (label != null) {
            this.descriptionLabel.setText(label);
            this.saveButton.setVisible(false);
        } else {
            this.descriptionLabel.setVisible(false);
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ContainerPanel.this.actionSave();
                }
            });
        }
    }

    private void initComponents() {
        this.contentsPanel = new JPanel();
        this.descriptionLabel = new JLabel();
        this.saveButton = new JButton();
        this.contentsPanel.setLayout(new BoxLayout(this.contentsPanel, 3));
        this.descriptionLabel.setText("jLabel1");
        this.saveButton.setText("Save");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.contentsPanel, -1, 219, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.descriptionLabel).addPreferredGap(0, 109, Short.MAX_VALUE).add((Component)this.saveButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descriptionLabel).add((Component)this.saveButton)).addPreferredGap(0).add((Component)this.contentsPanel, -1, 107, Short.MAX_VALUE).addContainerGap()));
    }

    public void setFields(Dictionary rootDict) {
        String[] keys;
        this.contentsPanel.removeAll();
        for (String key : keys = rootDict.getKeys()) {
            JPanel panel;
            System.err.println("setFields processing key \"" + key + "\"...");
            StructElement curElem = rootDict.getElement(key);
            System.err.println("  curElem = " + curElem);
            if (curElem instanceof StringRepresentableField) {
                StringRepresentableField curField = (StringRepresentableField)curElem;
                panel = new EditStringValuePanel();
                ((EditStringValuePanel)panel).setDecription(key + " (" + curField.getTypeName() + ")");
                ((EditStringValuePanel)panel).setValue(curField.getValueAsString());
                ((EditStringValuePanel)panel).setUserData(curField);
                System.err.println("  (1)adding " + panel + " to containerpanel");
                this.addComponent(panel);
                this.fields.add((EditStringValuePanel)panel);
                continue;
            }
            if (curElem instanceof Dictionary) {
                Dictionary curDict = (Dictionary)curElem;
                panel = new ContainerPanel(key + " (" + curDict.getTypeName() + ")");
                ((ContainerPanel)panel).setFields(curDict);
                System.err.println("  (2)adding " + panel + " to containerpanel");
                this.addComponent(panel);
                this.subPanels.add((ContainerPanel)panel);
                continue;
            }
            if (curElem instanceof Array) {
                Array curArray = (Array)curElem;
                panel = new ContainerPanel(key + " (" + curArray.getTypeName() + ")");
                ((ContainerPanel)panel).setFields(curArray);
                System.err.println("  (2)adding " + panel + " to containerpanel");
                this.addComponent(panel);
                this.subPanels.add((ContainerPanel)panel);
                continue;
            }
            throw new RuntimeException("Unknown StructElement type: " + curElem.getClass());
        }
        this.contentsPanel.add(Box.createVerticalGlue());
    }

    public void setFields(Array rootArray) {
        this.contentsPanel.removeAll();
        StructElement[] elements = rootArray.getElements();
        for (int i = 0; i < elements.length; ++i) {
            JPanel panel;
            StructElement curElem = elements[i];
            System.err.println("setFields processing array element...");
            System.err.println("  curElem = " + curElem);
            if (curElem instanceof StringRepresentableField) {
                StringRepresentableField curField = (StringRepresentableField)curElem;
                panel = new EditStringValuePanel();
                ((EditStringValuePanel)panel).setDecription("[" + i + "] (" + curField.getTypeName() + ")");
                ((EditStringValuePanel)panel).setValue(curField.getValueAsString());
                ((EditStringValuePanel)panel).setUserData(curField);
                System.err.println("  (1)adding " + panel + " to containerpanel");
                this.addComponent(panel);
                continue;
            }
            if (curElem instanceof Dictionary) {
                Dictionary curDict = (Dictionary)curElem;
                panel = new ContainerPanel("[" + i + "] (" + curDict.getTypeName() + ")");
                ((ContainerPanel)panel).setFields(curDict);
                System.err.println("  (2)adding " + panel + " to containerpanel");
                this.addComponent(panel);
                continue;
            }
            if (curElem instanceof Array) {
                Array curArray = (Array)curElem;
                panel = new ContainerPanel("[" + i + "] (" + curArray.getTypeName() + ")");
                ((ContainerPanel)panel).setFields(curArray);
                System.err.println("  (3)adding " + panel + " to containerpanel");
                this.addComponent(panel);
                continue;
            }
            throw new RuntimeException("Unknown StructElement type: " + curElem.getClass());
        }
        this.contentsPanel.add(Box.createVerticalGlue());
    }

    private void actionSave() {
        List<EditStringValuePanel> modifiedFields = this.getModifiedFields();
        if (modifiedFields.size() == 0) {
            JOptionPane.showMessageDialog(this, "Nothing to save.", "Information", 1);
            return;
        }
        StringBuilder messageBuilder = new StringBuilder();
        for (EditStringValuePanel vp : modifiedFields) {
            StringRepresentableField field = vp.getUserData();
            String validateRes = field.validateStringValue(vp.getValue());
            if (validateRes == null) continue;
            messageBuilder.append(vp.getDescription()).append(": ").append(vp.getValue());
            messageBuilder.append(" [").append(validateRes).append("]\n");
        }
        if (messageBuilder.length() != 0) {
            JOptionPane.showMessageDialog(this, "The following fields failed to validate:\n\n" + messageBuilder.toString(), "Error", 0);
        } else {
            messageBuilder.append("The following modifications were made:\n\n");
            for (EditStringValuePanel vp : modifiedFields) {
                messageBuilder.append(vp.getDescription()).append(": \"").append(vp.getValue()).append("\"\n");
            }
            messageBuilder.append("\nCarry on with save?");
            JOptionPane.showConfirmDialog(this, messageBuilder.toString(), "Confirm save", 0, 3);
        }
    }

    private List<EditStringValuePanel> getModifiedFields() {
        LinkedList<EditStringValuePanel> tmpList = new LinkedList<EditStringValuePanel>();
        for (EditStringValuePanel field : this.fields) {
            if (!field.isModified()) continue;
            tmpList.add(field);
        }
        for (ContainerPanel cp : this.subPanels) {
            tmpList.addAll(cp.getModifiedFields());
        }
        return tmpList;
    }

    private void addComponent(JComponent jc) {
        this.contentsPanel.add(jc);
    }
}

