/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.jarRepository;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoriesConfiguration;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryDescription;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryService;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public final class JpsRemoteRepositoriesConfigurationSerializer
extends JpsProjectExtensionSerializer {
    private static final String ELEMENT_TAG = "remote-repository";
    private static final String OPTION_TAG = "option";
    private static final String ID_PROPERTY = "id";
    private static final String NAME_PROPERTY = "name";
    private static final String URL_PROPERTY = "url";

    public JpsRemoteRepositoriesConfigurationSerializer() {
        super("jarRepositories.xml", "RemoteRepositoriesConfiguration");
    }

    @Override
    public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            JpsRemoteRepositoriesConfigurationSerializer.$$$reportNull$$$0(0);
        }
        if (componentTag == null) {
            JpsRemoteRepositoriesConfigurationSerializer.$$$reportNull$$$0(1);
        }
        ArrayList<JpsRemoteRepositoryDescription> result = new ArrayList<JpsRemoteRepositoryDescription>();
        List children = componentTag.getChildren(ELEMENT_TAG);
        for (Element repoElement : children) {
            String id = null;
            String name = null;
            String url = null;
            for (Element element : repoElement.getChildren(OPTION_TAG)) {
                String option = element.getAttributeValue(NAME_PROPERTY);
                String optionValue = element.getAttributeValue("value");
                if (ID_PROPERTY.equals(option)) {
                    id = optionValue;
                    continue;
                }
                if (NAME_PROPERTY.equals(option)) {
                    name = optionValue == null ? "" : optionValue;
                    continue;
                }
                if (!URL_PROPERTY.equals(option)) continue;
                url = optionValue;
            }
            if (id == null || url == null) continue;
            result.add(new JpsRemoteRepositoryDescription(id, name, url));
        }
        JpsRemoteRepositoriesConfiguration config = JpsRemoteRepositoryService.getInstance().getOrCreateRemoteRepositoriesConfiguration(project);
        if (!result.isEmpty()) {
            config.setRepositories(result);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "componentTag";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/model/serialization/jarRepository/JpsRemoteRepositoriesConfigurationSerializer";
        objectArray[2] = "loadExtension";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

