/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformations;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public final class ChangeToOperatorInspection
extends BaseInspection {
    public boolean useDoubleNegation = true;
    public boolean shouldChangeCompareToEqualityToEquals = true;
    public boolean withoutAdditionalParentheses = false;

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCall) {
                GrExpression invokedExpression;
                if (methodCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((invokedExpression = methodCall.getInvokedExpression()) instanceof GrReferenceExpression)) {
                    return;
                }
                GrReferenceExpression referenceExpression = (GrReferenceExpression)invokedExpression;
                if (referenceExpression.getDotTokenType() != GroovyTokenTypes.mDOT) {
                    return;
                }
                PsiElement highlightElement = referenceExpression.getReferenceNameElement();
                if (highlightElement == null) {
                    return;
                }
                String methodName = ChangeToOperatorInspection.this.getMethodName(methodCall);
                if (methodName == null) {
                    return;
                }
                Transformation transformation = Transformations.TRANSFORMATIONS.get(methodName);
                if (transformation == null) {
                    return;
                }
                if (transformation.couldApply(methodCall, ChangeToOperatorInspection.this.getOptions())) {
                    this.registerError(highlightElement, GroovyBundle.message("replace.with.operator.message", methodName), new LocalQuickFix[]{new OperatorToMethodFix(transformation, methodName, ChangeToOperatorInspection.this.getOptions())}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    @Nullable
    public String getMethodName(@NotNull GrMethodCall methodCall) {
        PsiMethod method;
        if (methodCall == null) {
            ChangeToOperatorInspection.$$$reportNull$$$0(0);
        }
        if ((method = methodCall.resolveMethod()) == null || method.hasModifierProperty("static")) {
            return null;
        }
        return method.getName();
    }

    @Override
    @NotNull
    public OptPane getGroovyOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"useDoubleNegation", (String)GroovyBundle.message("replace.with.operator.double.negation.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"shouldChangeCompareToEqualityToEquals", (String)GroovyBundle.message("replace.with.operator.compareTo.equality.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"withoutAdditionalParentheses", (String)GroovyBundle.message("replace.with.operator.parentheses", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ChangeToOperatorInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    private Options getOptions() {
        return new Options(this.useDoubleNegation, this.shouldChangeCompareToEqualityToEquals, this.withoutAdditionalParentheses);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static final class Options {
        private final boolean useDoubleNegation;
        private final boolean shouldChangeCompareToEqualityToEquals;
        private final boolean withoutAdditionalParentheses;

        public Options(boolean useDoubleNegation, boolean shouldChangeCompareToEqualityToEquals, boolean withoutAdditionalParentheses) {
            this.useDoubleNegation = useDoubleNegation;
            this.shouldChangeCompareToEqualityToEquals = shouldChangeCompareToEqualityToEquals;
            this.withoutAdditionalParentheses = withoutAdditionalParentheses;
        }

        public boolean useDoubleNegation() {
            return this.useDoubleNegation;
        }

        public boolean shouldChangeCompareToEqualityToEquals() {
            return this.shouldChangeCompareToEqualityToEquals;
        }

        public boolean withoutAdditionalParentheses() {
            return this.withoutAdditionalParentheses;
        }
    }

    private static class OperatorToMethodFix
    extends PsiUpdateModCommandQuickFix {
        private final Transformation myTransformation;
        private final String methodName;
        private final Options myOptions;

        private OperatorToMethodFix(Transformation transformation, String name, Options options) {
            this.myTransformation = transformation;
            this.methodName = name;
            this.myOptions = options;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("replace.with.operator.fix", this.methodName);
            if (string == null) {
                OperatorToMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement call;
            if (project == null) {
                OperatorToMethodFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                OperatorToMethodFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                OperatorToMethodFix.$$$reportNull$$$0(3);
            }
            if ((call = element.getParent()) == null) {
                return;
            }
            if (!((call = call.getParent()) instanceof GrMethodCall)) {
                return;
            }
            GrMethodCall methodCall = (GrMethodCall)call;
            GrExpression invokedExpression = methodCall.getInvokedExpression();
            if (!(invokedExpression instanceof GrReferenceExpression)) {
                return;
            }
            if (!this.myTransformation.couldApply(methodCall, this.myOptions)) {
                return;
            }
            this.myTransformation.apply(methodCall, this.myOptions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$OperatorToMethodFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$OperatorToMethodFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

