/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.grid.editors.DefaultBlobEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultBooleanEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultDateEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultNumericEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTextEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTimeEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTimestampEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.util.ui.CalendarView;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorFactoryImpl
implements GridCellEditorFactoryProvider {
    private static final GridCellEditorFactoryImpl INSTANCE = new GridCellEditorFactoryImpl();
    protected final List<? extends GridCellEditorFactory> myDefaultFactories = this.createFactories();

    protected List<? extends GridCellEditorFactory> createFactories() {
        return Arrays.asList(new DefaultNumericEditorFactory(), new DefaultDateEditorFactory(), new DefaultTimestampEditorFactory(CalendarView.Mode.DATE), new DefaultTimestampEditorFactory(CalendarView.Mode.TIME), new DefaultTimestampEditorFactory(CalendarView.Mode.DATETIME), new DefaultTimeEditorFactory(), new DefaultTextEditorFactory(), new DefaultBlobEditorFactory(), new DefaultBooleanEditorFactory());
    }

    public static GridCellEditorFactoryProvider getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public GridCellEditorFactory getEditorFactory(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            GridCellEditorFactoryImpl.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridCellEditorFactoryImpl.$$$reportNull$$$0(1);
        }
        if (column == null) {
            GridCellEditorFactoryImpl.$$$reportNull$$$0(2);
        }
        return GridCellEditorFactoryProvider.getEditorFactory(this.myDefaultFactories, factory -> factory.getSuitability(grid, row, column), GridCellEditorFactory.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "grid";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "row";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "column";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorFactoryImpl";
        objectArray[2] = "getEditorFactory";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

