/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperclassNotAccessibleFromInterfaceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuperclassNotAccessibleFromInterfaceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuperclassNotAccessibleFromInterfaceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperclassNotAccessibleFromInterfaceChecker\n+ 2 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n*L\n1#1,41:1\n95#2,3:42\n100#2:46\n95#3:45\n*S KotlinDebug\n*F\n+ 1 FirSuperclassNotAccessibleFromInterfaceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperclassNotAccessibleFromInterfaceChecker\n*L\n29#1:42,3\n29#1:46\n29#1:45\n*E\n"})
public final class FirSuperclassNotAccessibleFromInterfaceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuperclassNotAccessibleFromInterfaceChecker INSTANCE = new FirSuperclassNotAccessibleFromInterfaceChecker();

    private FirSuperclassNotAccessibleFromInterfaceChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        FirBasedSymbol firBasedSymbol;
        block8: {
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (FirHelpersKt.explicitReceiverIsNotSuperReference(expression2)) {
                return;
            }
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirBasedSymbol<?> it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirBasedSymbol firBasedSymbol2;
                FirBasedSymbol<?> firBasedSymbol3 = it$iv;
                if (!(firBasedSymbol3 instanceof FirClassSymbol)) {
                    firBasedSymbol3 = null;
                }
                if ((firBasedSymbol = (FirBasedSymbol)((FirClassSymbol)firBasedSymbol3)) == null) continue;
                FirBasedSymbol firBasedSymbol4 = firBasedSymbol2 = firBasedSymbol;
                boolean bl = false;
                FirBasedSymbol it = firBasedSymbol4;
                firBasedSymbol = true ? firBasedSymbol2 : null;
                if (firBasedSymbol == null) {
                    continue;
                }
                break block8;
            }
            firBasedSymbol = null;
        }
        FirClassSymbol firClassSymbol = (FirClassSymbol)firBasedSymbol;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol closestClass = firClassSymbol;
        if (closestClass.getClassKind() == ClassKind.INTERFACE) {
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
            FirClassLikeSymbol<?> firClassLikeSymbol = firCallableSymbol != null ? FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)firCallableSymbol) : null;
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
            if (containingClassSymbol.getSource() != null && containingClassSymbol.getClassKind() == ClassKind.CLASS && !Intrinsics.areEqual(containingClassSymbol.getClassId(), StandardClassIds.INSTANCE.getAny())) {
                FirExpression firExpression = expression2.getExplicitReceiver();
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null), FirErrors.INSTANCE.getSUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE(), null, 8, null);
            }
        }
    }
}

