/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsModuleCheckUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ(\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00100\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0002J-\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsModuleQualifiedAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "extractModuleCalleeSymbols", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "checkReifiedTypeParameters", "expr", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsModuleQualifiedAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsModuleQualifiedAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsModuleQualifiedAccessChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,66:1\n189#2,9:67\n*S KotlinDebug\n*F\n+ 1 FirJsModuleQualifiedAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsModuleQualifiedAccessChecker\n*L\n57#1:67,9\n*E\n"})
public final class FirJsModuleQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJsModuleQualifiedAccessChecker INSTANCE = new FirJsModuleQualifiedAccessChecker();

    private FirJsModuleQualifiedAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.checkReifiedTypeParameters(context2, reporter, expression2);
        List<Pair<FirBasedSymbol<?>, AbstractKtSourceElement>> calleeSymbols = this.extractModuleCalleeSymbols(expression2);
        for (Pair<FirBasedSymbol<?>, AbstractKtSourceElement> pair : calleeSymbols) {
            FirBasedSymbol<?> calleeSymbol = pair.component1();
            AbstractKtSourceElement source = pair.component2();
            AbstractKtSourceElement abstractKtSourceElement = source;
            if (abstractKtSourceElement == null) {
                abstractKtSourceElement = expression2.getSource();
            }
            FirJsModuleCheckUtilsKt.checkJsModuleUsage(context2, reporter, calleeSymbol, abstractKtSourceElement);
        }
    }

    private final List<Pair<FirBasedSymbol<?>, AbstractKtSourceElement>> extractModuleCalleeSymbols(FirQualifiedAccessExpression expression2) {
        List<Pair<FirBasedSymbol<?>, AbstractKtSourceElement>> list;
        FirExpression receiver;
        FirBasedSymbol calleeSymbol = FirReferenceUtilsKt.toResolvedBaseSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (calleeSymbol != null && FirHelpersKt.getContainingClassSymbol(calleeSymbol) == null) {
            return CollectionsKt.listOf(TuplesKt.to(calleeSymbol, expression2.getCalleeReference().getSource()));
        }
        FirExpression firExpression = expression2.getDispatchReceiver();
        FirExpression firExpression2 = receiver = firExpression != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null;
        if (receiver == null) {
            FirBasedSymbol firBasedSymbol = calleeSymbol;
            list = CollectionsKt.listOfNotNull(firBasedSymbol != null ? TuplesKt.to(firBasedSymbol, expression2.getCalleeReference().getSource()) : null);
        } else if (receiver instanceof FirResolvedQualifier) {
            FirClassLikeSymbol<?> classSymbol = ((FirResolvedQualifier)receiver).getSymbol();
            if (expression2 instanceof FirCallableReferenceAccess) {
                Pair[] pairArray = new Pair[2];
                FirClassLikeSymbol<?> firClassLikeSymbol = classSymbol;
                pairArray[0] = firClassLikeSymbol != null ? TuplesKt.to(firClassLikeSymbol, ((FirResolvedQualifier)receiver).getSource()) : null;
                FirBasedSymbol firBasedSymbol = calleeSymbol;
                pairArray[1] = firBasedSymbol != null ? TuplesKt.to(firBasedSymbol, ((FirCallableReferenceAccess)expression2).getCalleeReference().getSource()) : null;
                list = CollectionsKt.listOfNotNull(pairArray);
            } else {
                FirClassLikeSymbol<?> firClassLikeSymbol = classSymbol;
                list = CollectionsKt.listOfNotNull(firClassLikeSymbol != null ? TuplesKt.to(firClassLikeSymbol, expression2.getCalleeReference().getSource()) : null);
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReifiedTypeParameters(CheckerContext context2, DiagnosticReporter reporter, FirQualifiedAccessExpression expr) {
        block3: {
            FirFunctionCall firFunctionCall = expr instanceof FirFunctionCall ? (FirFunctionCall)expr : null;
            if (firFunctionCall == null) break block3;
            FirFunctionCall $this$forAllReifiedTypeParameters$iv = firFunctionCall;
            boolean $i$f$forAllReifiedTypeParameters = false;
            FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default($this$forAllReifiedTypeParameters$iv.getCalleeReference(), false, 1, null);
            if (firNamedFunctionSymbol != null) {
                FirNamedFunctionSymbol functionSymbol$iv = firNamedFunctionSymbol;
                for (Pair pair : CollectionsKt.zip((Iterable)functionSymbol$iv.getTypeParameterSymbols(), (Iterable)$this$forAllReifiedTypeParameters$iv.getTypeArguments())) {
                    FirRegularClassSymbol typeArgumentClass;
                    void typeArgument;
                    ConeKotlinType type$iv;
                    FirTypeParameterSymbol typeParameterSymbol$iv = (FirTypeParameterSymbol)pair.component1();
                    FirTypeProjection typeArgument$iv = (FirTypeProjection)pair.component2();
                    if (!typeParameterSymbol$iv.isReified() || !(typeArgument$iv instanceof FirTypeProjectionWithVariance) || FirTypeUtilsKt.getConeTypeOrNull(((FirTypeProjectionWithVariance)typeArgument$iv).getTypeRef()) == null) continue;
                    FirTypeProjectionWithVariance firTypeProjectionWithVariance = (FirTypeProjectionWithVariance)typeArgument$iv;
                    ConeKotlinType type = type$iv;
                    boolean bl = false;
                    if (ToSymbolUtilsKt.toRegularClassSymbol(type, context2.getSession()) == null) continue;
                    KtSourceElement ktSourceElement = typeArgument.getSource();
                    if (ktSourceElement == null && (ktSourceElement = ((FirFunctionCall)expr).getCalleeReference().getSource()) == null) {
                        ktSourceElement = ((FirFunctionCall)expr).getSource();
                    }
                    KtSourceElement source = ktSourceElement;
                    FirJsModuleCheckUtilsKt.checkJsModuleUsage(context2, reporter, typeArgumentClass, source);
                }
            }
        }
    }
}

