/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.components;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.load.java.AbstractJavaClassFinder;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J\b\u0010 \u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/javac/components/JavacBasedClassFinder;", "Lorg/jetbrains/kotlin/load/java/AbstractJavaClassFinder;", "<init>", "()V", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "initialize", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "codeAnalyzer", "Lorg/jetbrains/kotlin/resolve/lazy/KotlinCodeAnalyzer;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "findClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "request", "Lorg/jetbrains/kotlin/load/java/JavaClassFinder$Request;", "findClasses", "", "findPackage", "Lorg/jetbrains/kotlin/load/java/structure/JavaPackage;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "mayHaveAnnotations", "", "knownClassNamesInPackage", "", "", "packageFqName", "canComputeKnownClassNamesInPackage", "javac-wrapper"})
public final class JavacBasedClassFinder
extends AbstractJavaClassFinder {
    private JavacWrapper javac;

    @Override
    public void initialize(@NotNull BindingTrace trace, @NotNull KotlinCodeAnalyzer codeAnalyzer, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(codeAnalyzer, "codeAnalyzer");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(jvmTarget, "jvmTarget");
        this.javac = JavacWrapper.Companion.getInstance(this.getProject());
        super.initialize(trace, codeAnalyzer, languageVersionSettings, jvmTarget);
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        JavacWrapper javacWrapper = this.javac;
        if (javacWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException("javac");
            javacWrapper = null;
        }
        return javacWrapper.findClass(request.getClassId(), this.getJavaSearchScope());
    }

    @Override
    @NotNull
    public List<JavaClass> findClasses(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        return CollectionsKt.listOfNotNull(this.findClass(request));
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName, boolean mayHaveAnnotations) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        JavacWrapper javacWrapper = this.javac;
        if (javacWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException("javac");
            javacWrapper = null;
        }
        return javacWrapper.findPackage(fqName, this.getJavaSearchScope());
    }

    @Override
    @NotNull
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        JavacWrapper javacWrapper = this.javac;
        if (javacWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException("javac");
            javacWrapper = null;
        }
        return javacWrapper.knownClassNamesInPackage(packageFqName);
    }

    @Override
    public boolean canComputeKnownClassNamesInPackage() {
        return true;
    }
}

