/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.Nullable;

public final class ComboBoxUtil {
    public static void addToModel(DefaultComboBoxModel model, Object value, String label) {
        model.addElement(new Item(value, label));
    }

    public static <T> void setModel(JComboBox comboBox, DefaultComboBoxModel model, Collection<? extends T> values, Function<? super T, ? extends Pair<String, ?>> func) {
        model.removeAllElements();
        for (T each : values) {
            Pair pair = (Pair)func.fun(each);
            ComboBoxUtil.addToModel(model, pair.second, (String)pair.first);
        }
        comboBox.setModel(model);
    }

    public static void select(DefaultComboBoxModel model, Object value) {
        for (int i2 = 0; i2 < model.getSize(); ++i2) {
            Item comboBoxUtil = (Item)model.getElementAt(i2);
            if (!comboBoxUtil.getValue().equals(value)) continue;
            model.setSelectedItem(comboBoxUtil);
            return;
        }
        if (model.getSize() != 0) {
            model.setSelectedItem(model.getElementAt(0));
        }
    }

    @Nullable
    public static String getSelectedString(DefaultComboBoxModel model) {
        return String.valueOf(ComboBoxUtil.getSelectedValue(model));
    }

    @Nullable
    public static Object getSelectedValue(DefaultComboBoxModel model) {
        Object item = model.getSelectedItem();
        return item != null ? ((Item)item).getValue() : null;
    }

    private static final class Item {
        private final Object value;
        private final String label;

        private Item(Object value, String label) {
            this.value = value;
            this.label = label;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }
    }
}

