/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.extractFunction.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.refactoring.extractFunction.ExtractableCodeDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.extractFunction.ExtractableCodeDescriptorKt;
import org.jetbrains.kotlin.idea.k2.refactoring.extractFunction.ExtractableCodeDescriptorWithConflicts;
import org.jetbrains.kotlin.idea.k2.refactoring.extractFunction.ExtractionData;
import org.jetbrains.kotlin.idea.k2.refactoring.extractFunction.Parameter;
import org.jetbrains.kotlin.idea.k2.refactoring.extractFunction.ui.FirExtractFunctionParameterTablePanel;
import org.jetbrains.kotlin.idea.k2.refactoring.extractFunction.ui.PresentationUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IReplacement;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ParameterReplacement;
import org.jetbrains.kotlin.idea.refactoring.introduce.ui.KotlinSignatureComponent;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class KotlinFirExtractFunctionDialog
extends DialogWrapper {
    private JPanel contentPane;
    private TitledSeparator inputParametersPanel;
    private JComboBox visibilityBox;
    private KotlinSignatureComponent signaturePreviewField;
    private JPanel functionNamePanel;
    private NameSuggestionsField functionNameField;
    private JLabel functionNameLabel;
    private JComboBox<KtTypeCodeFragment> returnTypeBox;
    private JPanel returnTypePanel;
    private FirExtractFunctionParameterTablePanel parameterTablePanel;
    private final Project project;
    private final ExtractableCodeDescriptorWithConflicts originalDescriptor;
    private final Function1<ExtractableCodeDescriptor, Unit> onAccept;

    public KotlinFirExtractFunctionDialog(@NotNull Project project, @NotNull ExtractableCodeDescriptorWithConflicts originalDescriptor, @NotNull Function1<ExtractableCodeDescriptor, Unit> onAccept) {
        if (project == null) {
            KotlinFirExtractFunctionDialog.$$$reportNull$$$0(0);
        }
        if (originalDescriptor == null) {
            KotlinFirExtractFunctionDialog.$$$reportNull$$$0(1);
        }
        if (onAccept == null) {
            KotlinFirExtractFunctionDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.project = project;
        this.originalDescriptor = originalDescriptor;
        this.onAccept = onAccept;
        this.$$$setupUI$$$();
        this.setModal(true);
        this.setTitle(KotlinBundle.message((String)"extract.function", (Object[])new Object[0]));
        this.init();
        this.update();
    }

    private void createUIComponents() {
        this.signaturePreviewField = new KotlinSignatureComponent("", this.project);
    }

    private boolean isVisibilitySectionAvailable() {
        return ExtractUtilKt.isVisibilityApplicable(this.originalDescriptor.getDescriptor().getExtractionData());
    }

    private String getFunctionName() {
        return KtPsiUtilKt.quoteIfNeeded((String)this.functionNameField.getEnteredName());
    }

    @Nullable
    private KtModifierKeywordToken getVisibility() {
        if (!this.isVisibilitySectionAvailable()) {
            return null;
        }
        KtModifierKeywordToken value = (KtModifierKeywordToken)this.visibilityBox.getSelectedItem();
        return KtTokens.DEFAULT_VISIBILITY_KEYWORD.equals(value) ? null : value;
    }

    private boolean checkNames() {
        if (!KtPsiUtilKt.isIdentifier((String)this.getFunctionName())) {
            return false;
        }
        for (FirExtractFunctionParameterTablePanel.ParameterInfo parameterInfo : this.parameterTablePanel.getSelectedParameterInfos()) {
            if (KtPsiUtilKt.isIdentifier((String)parameterInfo.getName())) continue;
            return false;
        }
        return true;
    }

    private void update() {
        this.setOKActionEnabled(this.checkNames());
        ReadAction.nonBlocking(() -> PresentationUtilKt.getSignaturePreview(this.originalDescriptor.getDescriptor(), this.getFunctionName(), this.getVisibility(), this.parameterTablePanel.getSelectedReceiverInfo(), this.parameterTablePanel.getSelectedParameterInfos(), (KtTypeCodeFragment)this.returnTypeBox.getSelectedItem(), this.originalDescriptor.getDescriptor().getContext())).expireWith(this.getDisposable()).finishOnUiThread(ModalityState.stateForComponent((Component)((Object)this.signaturePreviewField)), preview -> this.signaturePreviewField.setText((String)preview)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    protected void init() {
        super.init();
        ExtractableCodeDescriptor extractableCodeDescriptor = this.originalDescriptor.getDescriptor();
        this.functionNameField = new NameSuggestionsField(new String[]{extractableCodeDescriptor.getName()}, this.project, (FileType)PlainTextFileType.INSTANCE);
        this.functionNameField.addDataChangedListener(() -> this.update());
        this.functionNamePanel.add((Component)this.functionNameField, "Center");
        this.functionNameLabel.setLabelFor((Component)this.functionNameField);
        final KtElement context = this.originalDescriptor.getDescriptor().getContext();
        List<KaType> possibleReturnTypes = ExtractableCodeDescriptorKt.getPossibleReturnTypes(extractableCodeDescriptor.getControlFlow());
        if (!possibleReturnTypes.isEmpty()) {
            List fragments = ContainerUtil.map(possibleReturnTypes, t -> new KtPsiFactory(this.project).createTypeCodeFragment(PresentationUtilKt.render(t, context), (PsiElement)context));
            DefaultComboBoxModel<KtTypeCodeFragment> returnTypeBoxModel = new DefaultComboBoxModel<KtTypeCodeFragment>(fragments.toArray(new KtTypeCodeFragment[0]));
            this.returnTypeBox.setModel(returnTypeBoxModel);
            this.returnTypeBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(JList list2, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
                    @NlsSafe String text = ((KtTypeCodeFragment)value).getText();
                    this.setText(text);
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return v0;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/k2/refactoring/extractFunction/ui/KotlinFirExtractFunctionDialog$1", "getListCellRendererComponent"));
                }
            });
            this.returnTypeBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(@NotNull ItemEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    KotlinFirExtractFunctionDialog.this.update();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/k2/refactoring/extractFunction/ui/KotlinFirExtractFunctionDialog$2", "itemStateChanged"));
                }
            });
        } else {
            this.returnTypePanel.getParent().remove(this.returnTypePanel);
        }
        this.visibilityBox.setModel(new DefaultComboBoxModel<IElementType>(KtTokens.VISIBILITY_MODIFIERS.getTypes()));
        boolean enableVisibility = this.isVisibilitySectionAvailable();
        this.visibilityBox.setEnabled(enableVisibility);
        if (enableVisibility) {
            KtModifierKeywordToken defaultVisibility = extractableCodeDescriptor.getVisibility();
            this.visibilityBox.setSelectedItem(defaultVisibility);
        }
        this.visibilityBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                KotlinFirExtractFunctionDialog.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/k2/refactoring/extractFunction/ui/KotlinFirExtractFunctionDialog$3", "itemStateChanged"));
            }
        });
        this.parameterTablePanel = new FirExtractFunctionParameterTablePanel(){

            @Override
            @NotNull
            public KtElement getContext() {
                KtElement ktElement = context;
                if (ktElement == null) {
                    4.$$$reportNull$$$0(0);
                }
                return ktElement;
            }

            @Override
            protected void updateSignature() {
                KotlinFirExtractFunctionDialog.this.update();
            }

            @Override
            protected void onEnterAction() {
                KotlinFirExtractFunctionDialog.this.doOKAction();
            }

            @Override
            protected void onCancelAction() {
                KotlinFirExtractFunctionDialog.this.doCancelAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/k2/refactoring/extractFunction/ui/KotlinFirExtractFunctionDialog$4", "getContext"));
            }
        };
        this.parameterTablePanel.init(extractableCodeDescriptor.getReceiverParameter(), extractableCodeDescriptor.getParameters());
        this.inputParametersPanel.setText(KotlinBundle.message((String)"text.parameters", (Object[])new Object[0]));
        this.inputParametersPanel.setLabelFor((Component)this.parameterTablePanel.getTable());
        this.inputParametersPanel.add((Component)this.parameterTablePanel);
    }

    protected void doOKAction() {
        final ExtractableCodeDescriptorWithConflicts result2 = PresentationUtilKt.validate(this.originalDescriptor.getDescriptor(), this.getFunctionName(), this.getVisibility(), this.parameterTablePanel.getSelectedReceiverInfo(), this.parameterTablePanel.getSelectedParameterInfos(), (KtTypeCodeFragment)this.returnTypeBox.getSelectedItem(), this.originalDescriptor.getDescriptor().getContext());
        MultiMap<PsiElement, String> conflicts = result2.getConflicts();
        conflicts.values().removeAll(this.originalDescriptor.getConflicts().values());
        KotlinCommonRefactoringUtilKt.checkConflictsInteractively(this.project, conflicts, new Function0<Unit>(){

            public Unit invoke() {
                KotlinFirExtractFunctionDialog.this.close(0);
                return Unit.INSTANCE;
            }
        }, new Function0<Unit>(){

            public Unit invoke() {
                KotlinFirExtractFunctionDialog.super.doOKAction();
                return (Unit)KotlinFirExtractFunctionDialog.this.onAccept.invoke((Object)result2.getDescriptor());
            }
        });
        this.close(0);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.functionNameField.getFocusableComponent();
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @NotNull
    protected JComponent createContentPane() {
        JPanel jPanel = this.contentPane;
        if (jPanel == null) {
            KotlinFirExtractFunctionDialog.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public static ExtractableCodeDescriptor createNewDescriptor(@NotNull ExtractableCodeDescriptor originalDescriptor, @NotNull String newName, @Nullable KtModifierKeywordToken newVisibility, @Nullable FirExtractFunctionParameterTablePanel.ParameterInfo newReceiverInfo, @NotNull List<FirExtractFunctionParameterTablePanel.ParameterInfo> newParameterInfos, @Nullable KaType returnType) {
        Parameter newReceiver;
        if (originalDescriptor == null) {
            KotlinFirExtractFunctionDialog.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            KotlinFirExtractFunctionDialog.$$$reportNull$$$0(5);
        }
        if (newParameterInfos == null) {
            KotlinFirExtractFunctionDialog.$$$reportNull$$$0(6);
        }
        LinkedHashMap<Parameter, Parameter> oldToNewParameters = new LinkedHashMap<Parameter, Parameter>();
        for (FirExtractFunctionParameterTablePanel.ParameterInfo parameterInfo : newParameterInfos) {
            oldToNewParameters.put((Parameter)parameterInfo.getOriginalParameter(), parameterInfo.toParameter());
        }
        Parameter originalReceiver = originalDescriptor.getReceiverParameter();
        Parameter parameter = newReceiver = newReceiverInfo != null ? newReceiverInfo.toParameter() : null;
        if (originalReceiver != null && newReceiver != null) {
            oldToNewParameters.put(originalReceiver, newReceiver);
        }
        ExtractionData data = originalDescriptor.getExtractionData();
        MultiMap newReplacementMap = MultiMap.create();
        originalDescriptor.getReplacementMap().entrySet().forEach(entry -> {
            List newReplacement = ContainerUtil.map((Collection)((Collection)entry.getValue()), p -> {
                if (p instanceof ParameterReplacement) {
                    ParameterReplacement r = p;
                    Parameter newParameter = (Parameter)oldToNewParameters.get(r.getParameter());
                    return newParameter != null ? r.copy(newParameter) : p;
                }
                return p;
            });
            newReplacementMap.putValues((Object)((KtSimpleNameExpression)entry.getKey()), (Collection)newReplacement);
        });
        return new ExtractableCodeDescriptor(originalDescriptor.getContext(), data, List.of(newName), newVisibility, oldToNewParameters.values().stream().filter(p -> p != newReceiver).toList(), newReceiver, originalDescriptor.getTypeParameters(), (MultiMap<KtSimpleNameExpression, IReplacement<KaType>>)newReplacementMap, originalDescriptor.getControlFlow(), returnType, originalDescriptor.getModifiers(), originalDescriptor.getOptInMarkers(), originalDescriptor.getRenderedAnnotations());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        JLabel jLabel;
        TitledSeparator titledSeparator;
        JPanel jPanel3;
        this.createUIComponents();
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        this.inputParametersPanel = titledSeparator = new TitledSeparator();
        titledSeparator.setLayout(new BorderLayout(0, 0));
        titledSeparator.setText("");
        jPanel5.add((Component)titledSeparator, "Center");
        titledSeparator.setBorder(BorderFactory.createTitledBorder(null, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinFirExtractFunctionDialog.class).getString("title.parameters"), 0, 0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(-1, 200), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(null, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinFirExtractFunctionDialog.class).getString("signature.preview"), 0, 0, null, null));
        KotlinSignatureComponent kotlinSignatureComponent = this.signaturePreviewField;
        kotlinSignatureComponent.setText("");
        jPanel7.add((Component)((Object)kotlinSignatureComponent), new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(500, 100), new Dimension(500, 100), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setEnabled(true);
        ((Component)jPanel8).setVisible(true);
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.functionNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinFirExtractFunctionDialog.class).getString("name"));
        jPanel8.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinFirExtractFunctionDialog.class).getString("visibility"));
        ((Component)jLabel2).setVisible(true);
        jPanel8.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(114, 16), null));
        this.functionNamePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.visibilityBox = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("private");
        defaultComboBoxModel.addElement("protected");
        defaultComboBoxModel.addElement("internal");
        defaultComboBoxModel.addElement("public");
        jComboBox.setModel(defaultComboBoxModel);
        ((Component)jComboBox).setVisible(true);
        jPanel8.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 0, 2, 0, null, new Dimension(114, 26), null));
        this.returnTypePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinFirExtractFunctionDialog.class).getString("return.type"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.returnTypeBox = jComboBox2;
        jPanel.add(jComboBox2, new GridConstraints(1, 0, 1, 2, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onAccept";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/k2/refactoring/extractFunction/ui/KotlinFirExtractFunctionDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameterInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/k2/refactoring/extractFunction/ui/KotlinFirExtractFunctionDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

