/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.copyPaste;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.util.ApplicationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.j2k.copyPaste.ConversionData;
import org.jetbrains.kotlin.j2k.copyPaste.ConversionResult;
import org.jetbrains.kotlin.j2k.copyPaste.CopyPasteConversionUtilsKt;
import org.jetbrains.kotlin.j2k.copyPaste.ElementAndTextList;
import org.jetbrains.kotlin.j2k.copyPaste.PlainTextPasteImportResolver;
import org.jetbrains.kotlin.j2k.copyPaste.TargetData;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.nj2k.KotlinNJ2KBundle;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/j2k/copyPaste/J2KTextCopyPasteConverter;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "conversionData", "Lorg/jetbrains/kotlin/j2k/copyPaste/ConversionData;", "targetData", "Lorg/jetbrains/kotlin/j2k/copyPaste/TargetData;", "j2kKind", "Lorg/jetbrains/kotlin/j2k/J2kConverterExtension$Kind;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/j2k/copyPaste/ConversionData;Lorg/jetbrains/kotlin/j2k/copyPaste/TargetData;Lorg/jetbrains/kotlin/j2k/J2kConverterExtension$Kind;)V", "convert", "", "tryToResolveImports", "Lorg/jetbrains/kotlin/j2k/copyPaste/ElementAndTextList;", "targetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nJ2KTextCopyPasteConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 J2KTextCopyPasteConverter.kt\norg/jetbrains/kotlin/j2k/copyPaste/J2KTextCopyPasteConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1374#2:90\n1460#2,5:91\n*S KotlinDebug\n*F\n+ 1 J2KTextCopyPasteConverter.kt\norg/jetbrains/kotlin/j2k/copyPaste/J2KTextCopyPasteConverter\n*L\n76#1:90\n76#1:91,5\n*E\n"})
public final class J2KTextCopyPasteConverter {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final ConversionData conversionData;
    @NotNull
    private final TargetData targetData;
    @NotNull
    private final J2kConverterExtension.Kind j2kKind;

    public J2KTextCopyPasteConverter(@NotNull Project project, @NotNull Editor editor, @NotNull ConversionData conversionData, @NotNull TargetData targetData, @NotNull J2kConverterExtension.Kind j2kKind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)conversionData, (String)"conversionData");
        Intrinsics.checkNotNullParameter((Object)targetData, (String)"targetData");
        Intrinsics.checkNotNullParameter((Object)((Object)j2kKind), (String)"j2kKind");
        this.project = project;
        this.editor = editor;
        this.conversionData = conversionData;
        this.targetData = targetData;
        this.j2kKind = j2kKind;
    }

    public final void convert() {
        ElementAndTextList additionalImports = this.tryToResolveImports(this.conversionData, this.targetData.getFile());
        ProgressManager.checkCanceled();
        KtImportList ktImportList = this.targetData.getFile().getImportList();
        int importsInsertOffset = ktImportList != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktImportList)) : 0;
        Ref.ObjectRef convertedImportsText = new Ref.ObjectRef();
        convertedImportsText.element = CopyPasteConversionUtilsKt.convertCodeToKotlin(additionalImports, this.project, this.targetData.getFile(), this.j2kKind).getText();
        if (this.targetData.getFile().getImportDirectives().isEmpty() && importsInsertOffset > 0) {
            convertedImportsText.element = "\n" + convertedImportsText.element;
        }
        ConversionResult conversionResult = CopyPasteConversionUtilsKt.convertCodeToKotlin(this.conversionData.getElementsAndTexts(), this.project, this.targetData.getFile(), this.j2kKind);
        String convertedText = conversionResult.getText();
        ProgressManager.checkCanceled();
        Object object = ActionsKt.runWriteAction(() -> J2KTextCopyPasteConverter.convert$lambda$0(convertedImportsText, this, importsInsertOffset, convertedText));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction(...)");
        RangeMarker boundsAfterReplace = (RangeMarker)object;
        PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
        if (this.j2kKind != J2kConverterExtension.Kind.K1_OLD) {
            PostProcessor postProcessor = J2kConverterExtension.createPostProcessor$default(J2kConverterExtension.Companion.extension(this.j2kKind), false, 1, null);
            for (FqName fqName2 : conversionResult.getImportsToAdd()) {
                postProcessor.insertImport(this.targetData.getFile(), fqName2);
            }
        }
        ProgressManager.checkCanceled();
        CopyPasteConversionUtilsKt.runPostProcessing(this.project, this.targetData.getFile(), RangeMarkersKt.getAsTextRange((RangeMarker)boundsAfterReplace), conversionResult.getConverterContext(), this.j2kKind);
    }

    private final ElementAndTextList tryToResolveImports(ConversionData conversionData, KtFile targetFile) {
        Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> J2KTextCopyPasteConverter.tryToResolveImports$lambda$3(this, conversionData, targetFile), KotlinNJ2KBundle.message("copy.text.adding.imports", new Object[0]), true, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
        return (ElementAndTextList)object;
    }

    private static final RangeMarker convert$lambda$0(Ref.ObjectRef $convertedImportsText, J2KTextCopyPasteConverter this$0, int $importsInsertOffset, String $convertedText) {
        if (!StringsKt.isBlank((CharSequence)((CharSequence)$convertedImportsText.element))) {
            this$0.targetData.getDocument().insertString($importsInsertOffset, (CharSequence)$convertedImportsText.element);
        }
        this$0.targetData.getDocument().replaceString(this$0.targetData.getBounds().getStartOffset(), this$0.targetData.getBounds().getEndOffset(), (CharSequence)$convertedText);
        int endOffsetAfterReplace = this$0.targetData.getBounds().getStartOffset() + $convertedText.length();
        this$0.editor.getCaretModel().moveToOffset(endOffsetAfterReplace);
        return this$0.targetData.getDocument().createRangeMarker(this$0.targetData.getBounds().getStartOffset(), endOffsetAfterReplace);
    }

    private static final PlainTextPasteImportResolver tryToResolveImports$lambda$3$lambda$1(J2KTextCopyPasteConverter this$0, ConversionData $conversionData, KtFile $targetFile) {
        return J2kConverterExtension.Companion.extension(this$0.j2kKind).createPlainTextPasteImportResolver($conversionData, $targetFile);
    }

    /*
     * WARNING - void declaration
     */
    private static final ElementAndTextList tryToResolveImports$lambda$3(J2KTextCopyPasteConverter this$0, ConversionData $conversionData, KtFile $targetFile) {
        void $this$flatMapTo$iv$iv;
        PlainTextPasteImportResolver resolver = (PlainTextPasteImportResolver)ApplicationKt.getApplication().runReadAction(() -> J2KTextCopyPasteConverter.tryToResolveImports$lambda$3$lambda$1(this$0, $conversionData, $targetFile));
        List<PsiImportStatementBase> imports2 = resolver.generateRequiredImports();
        Iterable $this$flatMap$iv = imports2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiImportStatementBase importStatement = (PsiImportStatementBase)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{"\n", importStatement};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List newlineSeparatedImports = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)"\n\n");
        return new ElementAndTextList(newlineSeparatedImports);
    }
}

