/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.patterns.AbstractTokenBasedRule;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenMatcher;
import org.languagetool.rules.patterns.Unifier;

public abstract class AbstractPatternRulePerformer {
    protected boolean prevMatched;
    protected AbstractTokenBasedRule rule;
    protected Unifier unifier;
    protected AnalyzedTokenReadings[] unifiedTokens;
    private final List<PatternTokenMatcher> patternTokenMatchers;
    private final int patternSize;
    private final int minOccurCorrection;
    @Nullable
    private final Map<PatternToken, List<List<AnalyzedToken>>> toUnify;
    @Nullable
    private final Map<PatternToken, List<AnalyzedTokenReadings>> neutralReadings;

    protected AbstractPatternRulePerformer(AbstractTokenBasedRule rule, Unifier unifier) {
        this.rule = Objects.requireNonNull(rule);
        this.unifier = Objects.requireNonNull(unifier);
        this.patternTokenMatchers = this.createElementMatchers();
        this.patternSize = this.patternTokenMatchers.size();
        this.minOccurCorrection = this.getMinOccurrenceCorrection();
        this.toUnify = rule.isTestUnification() ? new HashMap() : null;
        this.neutralReadings = rule.isTestUnification() ? new HashMap() : null;
    }

    private List<PatternTokenMatcher> createElementMatchers() {
        ArrayList<PatternTokenMatcher> patternTokenMatchers = new ArrayList<PatternTokenMatcher>(this.rule.patternTokens.size());
        for (PatternToken pToken : this.rule.patternTokens) {
            PatternTokenMatcher matcher = new PatternTokenMatcher(pToken);
            patternTokenMatchers.add(matcher);
        }
        return patternTokenMatchers;
    }

    protected void doMatch(AnalyzedSentence sentence, AnalyzedTokenReadings[] tokens, MatchConsumer consumer) throws IOException {
        int limit;
        AbstractTokenBasedRule.TokenHint anchor = this.rule.anchorHint;
        List<Integer> anchorIndices = anchor == null || this.isInterpretPosTagsPreDisambiguation() ? null : anchor.getPossibleIndices(sentence);
        int[] tokenPositions = new int[this.patternTokenMatchers.size()];
        int n = limit = this.rule.isSentStart() ? 1 : Math.max(0, tokens.length - this.patternSize + 1) + this.minOccurCorrection;
        if (anchorIndices != null) {
            for (Integer anchorIndex : anchorIndices) {
                int i = anchorIndex - anchor.tokenIndex;
                if (i < 0 || i >= limit) continue;
                this.matchFrom(i, tokens, consumer, tokenPositions);
            }
        } else {
            for (int i = 0; i < limit; ++i) {
                this.matchFrom(i, tokens, consumer, tokenPositions);
            }
        }
    }

    private void matchFrom(int startIndex, AnalyzedTokenReadings[] tokens, MatchConsumer consumer, int[] tokenPositions) throws IOException {
        PatternTokenMatcher pTokenMatcher = null;
        int skipShiftTotal = 0;
        boolean allElementsMatch = false;
        this.unifiedTokens = null;
        int matchingTokens = 0;
        int firstMatchToken = -1;
        int lastMatchToken = -1;
        int firstMarkerMatchToken = -1;
        int lastMarkerMatchToken = -1;
        int prevSkipNext = 0;
        if (this.toUnify != null) {
            this.toUnify.clear();
            Objects.requireNonNull(this.neutralReadings).clear();
        }
        int minOccurSkip = 0;
        for (int k = 0; k < this.patternSize; ++k) {
            PatternTokenMatcher prevTokenMatcher = pTokenMatcher;
            pTokenMatcher = this.patternTokenMatchers.get(k);
            pTokenMatcher.resolveReference(firstMatchToken, tokens, this.rule.getLanguage());
            int nextPos = startIndex + k + skipShiftTotal - minOccurSkip;
            this.prevMatched = false;
            if (prevSkipNext + nextPos >= tokens.length || prevSkipNext < 0) {
                prevSkipNext = tokens.length - (nextPos + 1);
            }
            int maxTok = Math.min(nextPos + prevSkipNext, tokens.length - (this.patternSize - k) + this.minOccurCorrection);
            for (int m = nextPos; m <= maxTok; ++m) {
                allElementsMatch = this.testAllReadings(tokens, pTokenMatcher, prevTokenMatcher, m, firstMatchToken, prevSkipNext);
                if (pTokenMatcher.getPatternToken().getMinOccurrence() == 0) {
                    boolean foundNext = false;
                    for (int k2 = k + 1; k2 < this.patternSize; ++k2) {
                        PatternTokenMatcher nextElement = this.patternTokenMatchers.get(k2);
                        boolean nextElementMatch = this.testAllReadings(tokens, nextElement, pTokenMatcher, m, firstMatchToken, prevSkipNext);
                        if (nextElementMatch) {
                            allElementsMatch = true;
                            ++minOccurSkip;
                            tokenPositions[matchingTokens++] = 0;
                            foundNext = true;
                            break;
                        }
                        if (nextElement.getPatternToken().getMinOccurrence() > 0) break;
                    }
                    if (foundNext) break;
                }
                if (!allElementsMatch) continue;
                int skipForMax = this.skipMaxTokens(tokens, pTokenMatcher, firstMatchToken, prevSkipNext, prevTokenMatcher, m, this.patternSize - k - 1);
                lastMatchToken = m + skipForMax;
                int skipShift = lastMatchToken - nextPos;
                tokenPositions[matchingTokens++] = skipShift + 1;
                prevSkipNext = this.translateElementNo(pTokenMatcher.getPatternToken().getSkipNext());
                skipShiftTotal += skipShift;
                if (firstMatchToken == -1) {
                    firstMatchToken = lastMatchToken - skipForMax;
                }
                if (firstMarkerMatchToken == -1 && pTokenMatcher.getPatternToken().isInsideMarker()) {
                    firstMarkerMatchToken = lastMatchToken - skipForMax;
                }
                if (!pTokenMatcher.getPatternToken().isInsideMarker()) break;
                lastMarkerMatchToken = lastMatchToken;
                break;
            }
            if (!allElementsMatch) break;
        }
        if (allElementsMatch && matchingTokens == this.patternSize && this.testUnification()) {
            consumer.consume(tokenPositions, firstMatchToken, lastMatchToken, firstMarkerMatchToken, lastMarkerMatchToken);
        }
    }

    protected boolean isInterpretPosTagsPreDisambiguation() {
        return this.rule instanceof PatternRule && ((PatternRule)this.rule).isInterpretPosTagsPreDisambiguation();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean testAllReadings(AnalyzedTokenReadings[] tokens, PatternTokenMatcher matcher, PatternTokenMatcher prevElement, int tokenNo, int firstMatchToken, int prevSkipNext) throws IOException {
        ChunkTag chunkTag;
        int i;
        boolean anyMatched = false;
        int numberOfReadings = tokens[tokenNo].getReadingsLength();
        matcher.prepareAndGroup(firstMatchToken, tokens, this.rule.getLanguage());
        ArrayList<AnalyzedToken> readingsToUnify = this.toUnify == null ? null : new ArrayList<AnalyzedToken>();
        for (i = 0; i < numberOfReadings; ++i) {
            AnalyzedToken matchToken = tokens[tokenNo].getAnalyzedToken(i);
            this.prevMatched = this.prevMatched || prevSkipNext > 0 && prevElement != null && prevElement.isMatchedByScopeNextException(matchToken);
            boolean bl = this.prevMatched = this.prevMatched || prevSkipNext == 0 && tokenNo <= tokens.length - 2 && matcher.isMatchedByScopeNextException(tokens[tokenNo + 1].getAnalyzedToken(0));
            if (this.prevMatched) {
                return false;
            }
            boolean readingTested = false;
            boolean readingMatches = false;
            if (!anyMatched) {
                anyMatched = readingMatches = matcher.isMatched(matchToken);
                readingTested = true;
            }
            if (!(anyMatched || prevElement != null && prevElement.getPatternToken().hasCurrentOrNextExceptions())) {
                if (matcher.getPatternToken().getPOStag() == null) {
                    if (!matcher.getPatternToken().isInflected()) return false;
                    if (tokens[tokenNo].hasSameLemmas()) {
                        return false;
                    }
                } else if (!matcher.getPatternToken().getPOSNegation() && !tokens[tokenNo].isTagged()) {
                    return false;
                }
            }
            if (!this.rule.isGroupsOrUnification()) continue;
            if (!readingTested) {
                readingMatches = matcher.isMatched(matchToken);
            }
            boolean isLastReading = i + 1 == numberOfReadings;
            PatternToken elem = matcher.getPatternToken();
            if (readingMatches && readingsToUnify != null && elem.isUnified() && !elem.isUnificationNeutral()) {
                readingsToUnify.add(matchToken);
            }
            anyMatched &= AbstractPatternRulePerformer.testAndGroup(isLastReading, matchToken, matcher);
        }
        if (anyMatched) {
            for (i = 0; i < numberOfReadings; ++i) {
                if (!matcher.isExceptionMatchedCompletely(tokens[tokenNo].getAnalyzedToken(i))) continue;
                return false;
            }
            if (tokenNo > 0 && matcher.hasPreviousException() && matcher.isMatchedByPreviousException(tokens[tokenNo - 1])) {
                return false;
            }
            if (matcher.getPatternToken().isUnificationNeutral() && this.neutralReadings != null) {
                this.neutralReadings.computeIfAbsent(matcher.getPatternToken(), __ -> new ArrayList()).add(tokens[tokenNo]);
            }
        }
        if ((chunkTag = matcher.getPatternToken().getChunkTag()) != null) {
            anyMatched = chunkTag.isRegexp() ? (anyMatched &= tokens[tokenNo].getChunkTags().stream().anyMatch(k -> k.getChunkTag().matches(chunkTag.getChunkTag())) ^ matcher.getPatternToken().getNegation()) : (anyMatched &= tokens[tokenNo].getChunkTags().contains(chunkTag) ^ matcher.getPatternToken().getNegation());
        }
        if (matcher.getPatternToken().hasAndGroup()) {
            for (PatternToken e : matcher.getPatternToken().getAndGroup()) {
                if (e.getChunkTag() == null) continue;
                anyMatched &= tokens[tokenNo].getChunkTags().contains(e.getChunkTag()) ^ e.getNegation();
            }
        }
        if (!anyMatched || readingsToUnify == null || readingsToUnify.isEmpty()) return anyMatched;
        this.toUnify.computeIfAbsent(matcher.getPatternToken(), __ -> new ArrayList()).add(readingsToUnify);
        return anyMatched;
    }

    private boolean testUnification() {
        if (this.toUnify == null || this.neutralReadings == null) {
            return true;
        }
        this.unifier.reset();
        for (PatternTokenMatcher matcher : this.patternTokenMatchers) {
            PatternToken patternToken = matcher.getPatternToken();
            List<AnalyzedTokenReadings> neutral = this.neutralReadings.get(patternToken);
            if (neutral != null) {
                for (AnalyzedTokenReadings atr : neutral) {
                    this.unifier.addNeutralElement(atr);
                }
                continue;
            }
            List<List<AnalyzedToken>> readingSets = this.toUnify.get(patternToken);
            if (readingSets == null) continue;
            for (List<AnalyzedToken> readings : readingSets) {
                boolean anyMatched = false;
                for (int i = 0; i < readings.size(); ++i) {
                    anyMatched |= this.unifier.isUnified(readings.get(i), patternToken.getUniFeatures(), i == readings.size() - 1);
                }
                if (patternToken.isUniNegated() && anyMatched) {
                    return false;
                }
                if (!patternToken.isLastInUnification() || readings != readingSets.get(readingSets.size() - 1)) continue;
                if (!anyMatched && !patternToken.isUniNegated()) {
                    return false;
                }
                if (this.rule.isGetUnified()) {
                    this.unifiedTokens = this.unifier.getFinalUnified();
                }
                this.unifier.reset();
            }
        }
        return true;
    }

    private static boolean testAndGroup(boolean lastReading, AnalyzedToken matchToken, PatternTokenMatcher elemMatcher) {
        elemMatcher.addMemberAndGroup(matchToken);
        return !lastReading || elemMatcher.checkAndGroup(true);
    }

    private int getMinOccurrenceCorrection() {
        int minOccurCorrection = 0;
        for (PatternToken patternToken : this.rule.getPatternTokens()) {
            if (patternToken.getMinOccurrence() != 0) continue;
            ++minOccurCorrection;
        }
        return minOccurCorrection;
    }

    private int skipMaxTokens(AnalyzedTokenReadings[] tokens, PatternTokenMatcher elem, int firstMatchToken, int prevSkipNext, PatternTokenMatcher prevElement, int m, int remainingElems) throws IOException {
        boolean nextAllElementsMatch;
        int maxSkip = 0;
        int maxOccurrences = elem.getPatternToken().getMaxOccurrence() == -1 ? Integer.MAX_VALUE : elem.getPatternToken().getMaxOccurrence();
        for (int j = 1; j < maxOccurrences && m + j < tokens.length - remainingElems && (nextAllElementsMatch = this.testAllReadings(tokens, elem, prevElement, m + j, firstMatchToken, prevSkipNext)); ++j) {
            ++maxSkip;
        }
        return maxSkip;
    }

    int translateElementNo(int i) {
        return i;
    }

    protected static interface MatchConsumer {
        public void consume(int[] var1, int var2, int var3, int var4, int var5) throws IOException;
    }
}

