/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.InvalidSmilesException;
import uk.ac.ebi.beam.Topology;

final class Generator {
    private final Graph g;
    private final StringBuilder sb;
    private final int[] visitedAt;
    private final int[] tmp;
    private int nVisit;
    private final AtomToken[] tokens;
    private final Map<Integer, List<RingClosure>> rings;
    private final RingNumbering rnums;

    Generator(Graph g, RingNumbering rnums) throws InvalidSmilesException {
        this(g, new int[g.order()], rnums);
    }

    Generator(Graph g, int[] visitedAt, RingNumbering rnums) throws InvalidSmilesException {
        int u;
        this.g = g;
        this.rnums = rnums;
        this.sb = new StringBuilder(g.order() * 2);
        this.visitedAt = visitedAt;
        this.tmp = new int[4];
        this.tokens = new AtomToken[g.order()];
        this.rings = new HashMap<Integer, List<RingClosure>>();
        Arrays.fill(visitedAt, -1);
        for (u = 0; u < g.order() && this.nVisit < g.order(); ++u) {
            if (visitedAt[u] >= 0) continue;
            this.prepare(u, u);
        }
        if (g.getFlags(4) != 0) {
            for (u = 0; u < g.order(); ++u) {
                if (g.topologyOf(u).configuration().type() != Configuration.Type.ExtendedTetrahedral) continue;
                this.setAllenalStereo(g, visitedAt, u);
            }
        }
        this.nVisit = 0;
        Arrays.fill(visitedAt, -1);
        for (u = 0; u < g.order() && this.nVisit < g.order(); ++u) {
            if (visitedAt[u] >= 0) continue;
            if (u > 0) {
                rnums.reset();
                this.write(u, u, Bond.DOT);
                continue;
            }
            this.write(u, u, Bond.IMPLICIT);
        }
    }

    private void setAllenalStereo(Graph g, int[] visitedAt, int u) {
        assert (g.degree(u) == 2);
        Edge a = g.edgeAt(u, 0);
        Edge b = g.edgeAt(u, 1);
        assert (a.bond() == Bond.DOUBLE && b.bond() == Bond.DOUBLE);
        int aAtom = a.other(u);
        int bAtom = b.other(u);
        if (this.rings.get(aAtom) == null && this.rings.get(bAtom) == null) {
            this.tokens[u].configure(g.topologyOf(u).configurationOf(visitedAt));
        } else {
            int[] tmp = Arrays.copyOf(visitedAt, visitedAt.length);
            if (visitedAt[aAtom] > visitedAt[bAtom]) {
                int swap = aAtom;
                aAtom = bAtom;
                bAtom = swap;
            }
            assert (this.rings.get(aAtom) == null || this.rings.get(aAtom).size() == 1);
            assert (this.rings.get(bAtom) == null || this.rings.get(bAtom).size() == 1);
            if (this.rings.get(aAtom) != null) {
                tmp[this.rings.get((Object)Integer.valueOf((int)aAtom)).get((int)0).other((int)aAtom)] = visitedAt[aAtom];
            }
            if (this.rings.get(bAtom) != null) {
                tmp[this.rings.get((Object)Integer.valueOf((int)bAtom)).get((int)0).other((int)bAtom)] = visitedAt[bAtom];
            }
            this.tokens[u].configure(g.topologyOf(u).configurationOf(tmp));
        }
    }

    void prepare(int u, int p) {
        ++this.nVisit;
        this.tokens[u] = this.g.atom(u).token();
        this.tokens[u].setGraph(this.g);
        this.tokens[u].setIdx(u);
        int d = this.g.degree(u);
        for (int j = 0; j < d; ++j) {
            Edge e = this.g.edgeAt(u, j);
            int v = e.other(u);
            if (this.visitedAt[v] < 0) {
                this.prepare(v, u);
                continue;
            }
            if (v == p || this.visitedAt[v] >= this.visitedAt[u]) continue;
            this.cyclicEdge(v, u, e.bond(v));
        }
        this.prepareStereochemistry(u, p);
    }

    private void prepareStereochemistry(int u, int prev) {
        Topology topology = this.g.topologyOf(u);
        if (topology != Topology.unknown()) {
            List<RingClosure> closures = this.rings.get(u);
            if (closures != null) {
                if (closures.size() == 1) {
                    int ring = closures.get(0).other(u);
                    int uAt = this.visitedAt[u];
                    int rAt = this.visitedAt[ring];
                    int n = prev;
                    this.visitedAt[n] = this.visitedAt[n] - 1;
                    int n2 = u;
                    this.visitedAt[n2] = this.visitedAt[n2] - 1;
                    this.visitedAt[ring] = uAt;
                    this.tokens[u].configure(topology.configurationOf(this.visitedAt));
                    int n3 = prev;
                    this.visitedAt[n3] = this.visitedAt[n3] + 1;
                    int n4 = u;
                    this.visitedAt[n4] = this.visitedAt[n4] + 1;
                    this.visitedAt[ring] = rAt;
                } else {
                    int i;
                    assert (closures.size() <= 4);
                    int n = prev;
                    this.visitedAt[n] = this.visitedAt[n] - 4;
                    int n5 = u;
                    this.visitedAt[n5] = this.visitedAt[n5] - 4;
                    int rank = this.visitedAt[u];
                    for (i = 0; i < closures.size(); ++i) {
                        int v = closures.get(i).other(u);
                        this.tmp[i] = this.visitedAt[v];
                        this.visitedAt[v] = ++rank;
                    }
                    this.tokens[u].configure(topology.configurationOf(this.visitedAt));
                    for (i = 0; i < closures.size(); ++i) {
                        this.visitedAt[closures.get((int)i).other((int)u)] = this.tmp[i];
                    }
                    int n6 = prev;
                    this.visitedAt[n6] = this.visitedAt[n6] + 4;
                    int n7 = u;
                    this.visitedAt[n7] = this.visitedAt[n7] + 4;
                }
            } else {
                this.tokens[u].configure(topology.configurationOf(this.visitedAt));
            }
        }
    }

    void write(int u, int p, Bond b) throws InvalidSmilesException {
        int v;
        List<RingClosure> closures;
        ++this.nVisit;
        int remaining = this.g.degree(u);
        if (u != p) {
            --remaining;
        }
        if ((closures = this.rings.get(u)) != null) {
            for (RingClosure rc : closures) {
                int rnum;
                if (rc.register(rnum = this.rnums.next())) {
                    v = rc.other(u);
                    this.tokens[u] = new RingNumberToken(new RingBondToken(this.tokens[u], rc.bond(u)), rnum);
                    this.rnums.use(rnum);
                } else {
                    this.tokens[u] = new RingNumberToken(this.tokens[u], rc.rnum);
                    this.rnums.free(rc.rnum);
                }
                --remaining;
            }
        }
        this.sb.append(b.token());
        this.tokens[u].append(this.sb);
        int d = this.g.degree(u);
        for (int j = 0; j < d; ++j) {
            Edge e = this.g.edgeAt(u, j);
            v = e.other(u);
            if (this.visitedAt[v] >= 0) continue;
            if (--remaining > 0) {
                this.sb.append('(');
                this.write(v, u, e.bond(u));
                this.sb.append(')');
                continue;
            }
            this.write(v, u, e.bond(u));
        }
    }

    private void cyclicEdge(int u, int v, Bond b) {
        RingClosure r = new RingClosure(u, v, b);
        this.addRing(r.u, r);
        this.addRing(r.v, r);
    }

    private void addRing(int u, RingClosure rc) {
        List<RingClosure> closures = this.rings.get(u);
        if (closures == null) {
            closures = new ArrayList<RingClosure>(2);
            this.rings.put(u, closures);
        }
        closures.add(rc);
    }

    String string() {
        return this.sb.toString();
    }

    static String generate(Graph g) throws InvalidSmilesException {
        return new Generator(g, new IterativeRingNumbering(1)).string();
    }

    static String generate(Graph g, int[] visitedAt) throws InvalidSmilesException {
        return new Generator(g, visitedAt, new IterativeRingNumbering(1)).string();
    }

    static final class IterativeRingNumbering
    implements RingNumbering {
        private boolean[] used = new boolean[100];
        private final int offset;
        private int pos;

        IterativeRingNumbering(int first) {
            this.pos = this.offset = first;
        }

        @Override
        public int next() throws InvalidSmilesException {
            while (this.pos < 100 && this.used[this.pos]) {
                ++this.pos;
            }
            if (this.pos < 100) {
                return this.pos;
            }
            this.pos = this.offset;
            while (this.pos < 100 && this.used[this.pos]) {
                ++this.pos;
            }
            if (this.pos < 100) {
                return this.pos;
            }
            throw new InvalidSmilesException("no more ring numbers can be assigned");
        }

        @Override
        public void use(int rnum) {
            this.used[rnum] = true;
        }

        @Override
        public void free(int rnum) {
            this.used[rnum] = false;
        }

        @Override
        public void reset() {
            this.pos = 1;
        }
    }

    static final class ReuseRingNumbering
    implements RingNumbering {
        private boolean[] used = new boolean[100];
        private final int offset;

        ReuseRingNumbering(int first) {
            this.offset = first;
        }

        @Override
        public int next() throws InvalidSmilesException {
            for (int i = this.offset; i < this.used.length; ++i) {
                if (this.used[i]) continue;
                return i;
            }
            throw new InvalidSmilesException("no available ring numbers");
        }

        @Override
        public void use(int rnum) {
            this.used[rnum] = true;
        }

        @Override
        public void free(int rnum) {
            this.used[rnum] = false;
        }

        @Override
        public void reset() {
        }
    }

    static interface RingNumbering {
        public int next() throws InvalidSmilesException;

        public void use(int var1);

        public void free(int var1);

        public void reset();
    }

    static final class RingBondToken
    extends TokenAdapter {
        Bond bond;

        RingBondToken(AtomToken p, Bond bond) {
            super(p);
            this.bond = bond;
        }

        @Override
        public void append(StringBuilder sb) {
            super.append(sb);
            sb.append((Object)this.bond);
        }
    }

    static final class RingNumberToken
    extends TokenAdapter {
        int rnum;

        RingNumberToken(AtomToken p, int rnum) {
            super(p);
            this.rnum = rnum;
        }

        @Override
        public void append(StringBuilder sb) {
            super.append(sb);
            if (this.rnum > 9) {
                sb.append('%');
            }
            sb.append(this.rnum);
        }
    }

    static abstract class TokenAdapter
    extends AtomToken {
        private AtomToken parent;

        TokenAdapter(AtomToken parent) {
            this.parent = parent;
        }

        @Override
        public final void configure(Configuration c) {
            this.parent.configure(c);
        }

        @Override
        public void append(StringBuilder sb) {
            this.parent.append(sb);
        }
    }

    static final class BracketToken
    extends AtomToken {
        private Atom atom;
        private Configuration c = Configuration.UNKNOWN;

        BracketToken(Atom a) {
            this.atom = a;
        }

        @Override
        public void configure(Configuration c) {
            this.c = c;
        }

        @Override
        public void append(StringBuilder sb) {
            boolean hExpand = this.atom.element() == Element.Hydrogen && this.g.degree(this.idx) == 0;
            sb.append('[');
            if (this.atom.isotope() >= 0) {
                sb.append(this.atom.isotope());
            }
            sb.append(this.atom.aromatic() ? this.atom.element().symbol().toLowerCase(Locale.ENGLISH) : this.atom.element().symbol());
            if (this.c != Configuration.UNKNOWN) {
                sb.append(this.c.shorthand().symbol());
            }
            if (this.atom.hydrogens() > 0 && !hExpand) {
                sb.append(Element.Hydrogen.symbol());
            }
            if (this.atom.hydrogens() > 1 && !hExpand) {
                sb.append(this.atom.hydrogens());
            }
            if (this.atom.charge() != 0) {
                sb.append(this.atom.charge() > 0 ? (char)'+' : '-');
                int absCharge = Math.abs(this.atom.charge());
                if (absCharge > 1) {
                    sb.append(absCharge);
                }
            }
            if (this.atom.atomClass() != 0) {
                sb.append(':').append(this.atom.atomClass());
            }
            sb.append(']');
            if (hExpand) {
                int h;
                for (h = this.atom.hydrogens(); h > 1; --h) {
                    sb.append("([H])");
                }
                if (h > 0) {
                    sb.append("[H]");
                }
            }
        }
    }

    static final class SubsetToken
    extends AtomToken {
        private final String str;

        SubsetToken(String str) {
            this.str = str;
        }

        @Override
        public void configure(Configuration c) {
        }

        @Override
        public void append(StringBuilder sb) {
            sb.append(this.str);
        }
    }

    static abstract class AtomToken {
        Graph g;
        int idx;

        AtomToken() {
        }

        void setGraph(Graph g) {
            this.g = g;
        }

        void setIdx(int idx) {
            this.idx = idx;
        }

        abstract void configure(Configuration var1);

        abstract void append(StringBuilder var1);
    }

    static final class RingClosure {
        final int u;
        final int v;
        final Bond b;
        int rnum = -1;

        RingClosure(int u, int v, Bond b) {
            this.u = u;
            this.v = v;
            this.b = b;
        }

        int other(int x) {
            if (x == this.u) {
                return this.v;
            }
            if (x == this.v) {
                return this.u;
            }
            throw new IllegalArgumentException("non edge endpoint");
        }

        Bond bond(int x) {
            if (x == this.u) {
                return this.b;
            }
            if (x == this.v) {
                return this.b.inverse();
            }
            throw new IllegalArgumentException("invalid endpoint");
        }

        boolean register(int rnum) {
            if (this.rnum < 0) {
                this.rnum = rnum;
                return true;
            }
            return false;
        }
    }
}

