/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Map;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.internals.AbstractConfigurableStoreFactory;
import org.apache.kafka.streams.kstream.internals.StreamJoinedInternal;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.DslKeyValueParams;
import org.apache.kafka.streams.state.DslStoreSuppliers;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.InMemoryWindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.LeftOrRightValueSerde;
import org.apache.kafka.streams.state.internals.ListValueStoreBuilder;
import org.apache.kafka.streams.state.internals.RocksDbWindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.TimestampedKeyAndJoinSideSerde;

public class OuterStreamJoinStoreFactory<K, V1, V2>
extends AbstractConfigurableStoreFactory {
    private final String name;
    private final StreamJoinedInternal<K, V1, V2> streamJoined;
    private final JoinWindows windows;
    private final DslStoreSuppliers passedInDslStoreSuppliers;
    private boolean loggingEnabled;

    public OuterStreamJoinStoreFactory(String name, StreamJoinedInternal<K, V1, V2> streamJoined, JoinWindows windows, Type type) {
        super(streamJoined.dslStoreSuppliers());
        this.passedInDslStoreSuppliers = streamJoined.passedInDslStoreSuppliers();
        this.name = OuterStreamJoinStoreFactory.buildOuterJoinWindowStoreName(streamJoined, name, type) + "-store";
        this.streamJoined = streamJoined;
        this.windows = windows;
        this.loggingEnabled = streamJoined.loggingEnabled();
    }

    @Override
    public StoreBuilder<?> builder() {
        Duration retentionPeriod = Duration.ofMillis(this.retentionPeriod());
        Duration windowSize = Duration.ofMillis(this.windows.size());
        String rpMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(retentionPeriod, "retentionPeriod");
        long retentionMs = ApiUtils.validateMillisecondDuration(retentionPeriod, rpMsgPrefix);
        String wsMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(windowSize, "windowSize");
        long windowSizeMs = ApiUtils.validateMillisecondDuration(windowSize, wsMsgPrefix);
        if (retentionMs < 0L) {
            throw new IllegalArgumentException("retentionPeriod cannot be negative");
        }
        if (windowSizeMs < 0L) {
            throw new IllegalArgumentException("windowSize cannot be negative");
        }
        if (windowSizeMs > retentionMs) {
            throw new IllegalArgumentException("The retention period of the window store " + this.name + " must be no smaller than its window size. Got size=[" + windowSizeMs + "], retention=[" + retentionMs + "]");
        }
        TimestampedKeyAndJoinSideSerde<K> timestampedKeyAndJoinSideSerde = new TimestampedKeyAndJoinSideSerde<K>(this.streamJoined.keySerde());
        LeftOrRightValueSerde<V1, V2> leftOrRightValueSerde = new LeftOrRightValueSerde<V1, V2>(this.streamJoined.valueSerde(), this.streamJoined.otherValueSerde());
        DslKeyValueParams dslKeyValueParams = new DslKeyValueParams(this.name, false);
        KeyValueBytesStoreSupplier supplier = this.passedInDslStoreSuppliers != null ? this.passedInDslStoreSuppliers.keyValueStore(dslKeyValueParams) : (this.streamJoined.thisStoreSupplier() != null ? (this.streamJoined.thisStoreSupplier() instanceof InMemoryWindowBytesStoreSupplier ? Stores.inMemoryKeyValueStore(this.name) : (this.streamJoined.thisStoreSupplier() instanceof RocksDbWindowBytesStoreSupplier ? Stores.persistentKeyValueStore(this.name) : this.dslStoreSuppliers().keyValueStore(dslKeyValueParams))) : this.dslStoreSuppliers().keyValueStore(dslKeyValueParams));
        ListValueStoreBuilder builder = new ListValueStoreBuilder(supplier, timestampedKeyAndJoinSideSerde, leftOrRightValueSerde, Time.SYSTEM);
        if (this.loggingEnabled) {
            builder.withLoggingEnabled(this.streamJoined.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        return builder;
    }

    @Override
    public long retentionPeriod() {
        return this.windows.size() + this.windows.gracePeriodMs();
    }

    @Override
    public long historyRetention() {
        throw new IllegalStateException("historyRetention is not supported when not a versioned store");
    }

    @Override
    public boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public String storeName() {
        return this.name;
    }

    @Override
    public boolean isWindowStore() {
        return false;
    }

    @Override
    public boolean isVersionedStore() {
        return false;
    }

    @Override
    public Map<String, String> logConfig() {
        return this.streamJoined.logConfig();
    }

    @Override
    public StoreFactory withCachingDisabled() {
        return this;
    }

    @Override
    public StoreFactory withLoggingDisabled() {
        this.loggingEnabled = false;
        return this;
    }

    @Override
    public boolean isCompatibleWith(StoreFactory storeFactory) {
        return storeFactory instanceof OuterStreamJoinStoreFactory && ((OuterStreamJoinStoreFactory)storeFactory).streamJoined.equals(this.streamJoined);
    }

    private static <K, V1, V2> String buildOuterJoinWindowStoreName(StreamJoinedInternal<K, V1, V2> streamJoinedInternal, String joinThisGeneratedName, Type type) {
        String outerJoinSuffix;
        String string = outerJoinSuffix = type == Type.RIGHT ? "-outer-shared-join" : "-left-shared-join";
        if (streamJoinedInternal.thisStoreSupplier() != null && !streamJoinedInternal.thisStoreSupplier().name().isEmpty()) {
            return streamJoinedInternal.thisStoreSupplier().name() + outerJoinSuffix;
        }
        if (streamJoinedInternal.storeName() != null) {
            return streamJoinedInternal.storeName() + outerJoinSuffix;
        }
        return "KSTREAM-OUTERSHARED-" + joinThisGeneratedName.substring(type == Type.RIGHT ? "KSTREAM-OUTERTHIS-".length() : "KSTREAM-JOINTHIS-".length());
    }

    public static enum Type {
        RIGHT,
        LEFT;

    }
}

