/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.util.Objects;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.pool.TypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CoreTypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerCacheProvider;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerClassFileLocator;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerClassLocator;

public class ModelTypePool
extends TypePool.Default
implements EnhancerClassLocator {
    private final EnhancerClassFileLocator locator;
    private final EnhancerCacheProvider poolCache;

    private ModelTypePool(EnhancerCacheProvider cacheProvider, EnhancerClassFileLocator classFileLocator, CoreTypePool parent) {
        super((TypePool.CacheProvider)cacheProvider, (ClassFileLocator)classFileLocator, TypePool.Default.ReaderMode.FAST, (TypePool)parent);
        this.poolCache = cacheProvider;
        this.locator = classFileLocator;
    }

    public static EnhancerClassLocator buildModelTypePool(ClassLoader classLoader) {
        return ModelTypePool.buildModelTypePool(ClassFileLocator.ForClassLoader.of((ClassLoader)classLoader));
    }

    public static EnhancerClassLocator buildModelTypePool(ClassFileLocator classFileLocator) {
        return ModelTypePool.buildModelTypePool(classFileLocator, new CoreTypePool());
    }

    public static EnhancerClassLocator buildModelTypePool(ClassFileLocator classFileLocator, CoreTypePool coreTypePool) {
        return ModelTypePool.buildModelTypePool(classFileLocator, coreTypePool, new EnhancerCacheProvider());
    }

    static EnhancerClassLocator buildModelTypePool(ClassFileLocator classFileLocator, CoreTypePool coreTypePool, EnhancerCacheProvider cacheProvider) {
        Objects.requireNonNull(classFileLocator);
        Objects.requireNonNull(coreTypePool);
        Objects.requireNonNull(cacheProvider);
        return new ModelTypePool(cacheProvider, new EnhancerClassFileLocator(cacheProvider, classFileLocator), coreTypePool);
    }

    @Override
    public void registerClassNameAndBytes(String className, byte[] bytes) {
        EnhancerCacheProvider.EnhancementState currentEnhancementState = this.poolCache.getEnhancementState();
        if (currentEnhancementState != null) {
            throw new IllegalStateException("Re-entrant enhancement is not supported: " + className);
        }
        EnhancerCacheProvider.EnhancementState state = new EnhancerCacheProvider.EnhancementState(className, (ClassFileLocator.Resolution)new ClassFileLocator.Resolution.Explicit(Objects.requireNonNull(bytes)));
        this.poolCache.setEnhancementState(state);
        state.setTypePoolResolution(this.doDescribe(className));
    }

    @Override
    public void deregisterClassNameAndBytes(String className) {
        this.poolCache.removeEnhancementState();
    }

    @Override
    public ClassFileLocator asClassFileLocator() {
        return this.locator;
    }
}

