/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.jboss.jandex.MethodInfo;

public final class ReflectiveMethodBuildItem
extends MultiBuildItem {
    final String declaringClass;
    final String name;
    final String[] params;
    final boolean queryOnly;
    final String reason;

    public ReflectiveMethodBuildItem(MethodInfo methodInfo) {
        this(null, false, methodInfo);
    }

    public ReflectiveMethodBuildItem(String reason, MethodInfo methodInfo) {
        this(reason, false, methodInfo);
    }

    public ReflectiveMethodBuildItem(boolean queryOnly, MethodInfo methodInfo) {
        this(null, queryOnly, methodInfo);
    }

    public ReflectiveMethodBuildItem(String reason, boolean queryOnly, MethodInfo methodInfo) {
        this(reason, queryOnly, methodInfo.declaringClass().name().toString(), methodInfo.name(), (String[])methodInfo.parameterTypes().stream().map(p -> p.name().toString()).toArray(String[]::new));
    }

    public ReflectiveMethodBuildItem(Method method) {
        this(false, method);
    }

    public ReflectiveMethodBuildItem(boolean queryOnly, Method method) {
        this(null, queryOnly, method);
    }

    public ReflectiveMethodBuildItem(String reason, boolean queryOnly, Method method) {
        this(reason, queryOnly, method.getDeclaringClass().getName(), method.getName(), (String[])Arrays.stream(method.getParameterTypes()).map(Class::getName).toArray(String[]::new));
    }

    public ReflectiveMethodBuildItem(String declaringClass, String name, String ... params) {
        this(null, false, declaringClass, name, params);
    }

    public ReflectiveMethodBuildItem(String reason, String declaringClass, String name, String ... params) {
        this(reason, false, declaringClass, name, params);
    }

    public ReflectiveMethodBuildItem(boolean queryOnly, String declaringClass, String name, String ... params) {
        this(null, queryOnly, declaringClass, name, params);
    }

    public ReflectiveMethodBuildItem(String reason, boolean queryOnly, String declaringClass, String name, String ... params) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.params = params;
        this.queryOnly = queryOnly;
        this.reason = reason;
    }

    public ReflectiveMethodBuildItem(String reason, String declaringClass, String name, Class<?> ... params) {
        this(reason, false, declaringClass, name, (String[])Arrays.stream(params).map(Class::getName).toArray(String[]::new));
    }

    public ReflectiveMethodBuildItem(String declaringClass, String name, Class<?> ... params) {
        this(false, declaringClass, name, params);
    }

    public ReflectiveMethodBuildItem(boolean queryOnly, String declaringClass, String name, Class<?> ... params) {
        this(null, queryOnly, declaringClass, name, (String[])Arrays.stream(params).map(Class::getName).toArray(String[]::new));
    }

    public String getName() {
        return this.name;
    }

    public String[] getParams() {
        return this.params;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isQueryOnly() {
        return this.queryOnly;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReflectiveMethodBuildItem that = (ReflectiveMethodBuildItem)((Object)o);
        return Objects.equals(this.declaringClass, that.declaringClass) && Objects.equals(this.name, that.name) && Arrays.equals(this.params, that.params);
    }

    public int hashCode() {
        int result = Objects.hash(this.declaringClass, this.name);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }
}

