/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongFunction;

public class MultiDemandCapping<T>
extends MultiOperator<T, T> {
    private final LongFunction<Long> function;

    public MultiDemandCapping(Multi<T> upstream, LongFunction<Long> function) {
        super(upstream);
        this.function = function;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        this.upstream().subscribe(new MultiDemandCappingProcessor(subscriber));
    }

    private class MultiDemandCappingProcessor
    extends MultiOperatorProcessor<T, T> {
        private final AtomicLong demand;

        MultiDemandCappingProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.demand = new AtomicLong();
        }

        @Override
        public void request(long numberOfItems) {
            Flow.Subscription subscription = this.getUpstreamSubscription();
            if (subscription == Subscriptions.CANCELLED) {
                return;
            }
            if (numberOfItems <= 0L) {
                this.onFailure(Subscriptions.getInvalidRequestException());
                return;
            }
            try {
                Subscriptions.add(this.demand, numberOfItems);
                long currentDemand = this.demand.get();
                long actualDemand = ParameterValidation.nonNull(MultiDemandCapping.this.function.apply(currentDemand), "actualDemand");
                if (actualDemand <= 0L) {
                    this.onFailure(new IllegalArgumentException("Invalid number of request, must be greater than 0"));
                    return;
                }
                if (actualDemand > currentDemand) {
                    this.onFailure(new IllegalStateException("The demand capping function computed a request of " + actualDemand + " elements while the outstanding demand is of " + numberOfItems + " elements"));
                    return;
                }
                Subscriptions.produced(this.demand, actualDemand);
                subscription.request(actualDemand);
            }
            catch (Throwable failure) {
                this.onFailure(failure);
            }
        }
    }
}

