/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.deployment;

import io.netty.util.internal.logging.AbstractInternalLogger;
import io.netty.util.internal.logging.FormattingTuple;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.MessageFormatter;
import org.jboss.logging.Logger;

public class JBossNettyLoggerFactory
extends InternalLoggerFactory {
    protected InternalLogger newInstance(String name) {
        return new JBossNettyInternalLogger(name);
    }

    private static final class JBossNettyInternalLogger
    extends AbstractInternalLogger {
        final Logger log;

        JBossNettyInternalLogger(String name) {
            super(name);
            this.log = Logger.getLogger((String)name);
        }

        public boolean isTraceEnabled() {
            return this.log.isTraceEnabled();
        }

        public void trace(String msg) {
            if (this.isTraceEnabled()) {
                this.log.trace((Object)msg);
            }
        }

        public void trace(String format, Object arg) {
            if (this.isTraceEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
                this.trace0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void trace(String format, Object argA, Object argB) {
            if (this.isTraceEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)argA, (Object)argB);
                this.trace0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void trace(String format, Object ... arguments) {
            if (this.isTraceEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)arguments);
                this.trace0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void trace(String msg, Throwable t) {
            if (this.isTraceEnabled()) {
                this.trace0(msg, t);
            }
        }

        private void trace0(String msg, Throwable t) {
            this.log.trace((Object)msg, t);
        }

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void debug(String msg) {
            if (this.isDebugEnabled()) {
                this.log.debug((Object)msg);
            }
        }

        public void debug(String format, Object arg) {
            if (this.isDebugEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
                this.debug0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void debug(String format, Object argA, Object argB) {
            if (this.isDebugEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)argA, (Object)argB);
                this.debug0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void debug(String format, Object ... arguments) {
            if (this.isDebugEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)arguments);
                this.debug0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void debug(String msg, Throwable t) {
            if (this.isDebugEnabled()) {
                this.debug0(msg, t);
            }
        }

        private void debug0(String msg, Throwable t) {
            this.log.debug((Object)msg, t);
        }

        public boolean isInfoEnabled() {
            return this.log.isInfoEnabled();
        }

        public void info(String msg) {
            if (this.isInfoEnabled()) {
                this.log.info((Object)msg);
            }
        }

        public void info(String format, Object arg) {
            if (this.isInfoEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
                this.info0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void info(String format, Object argA, Object argB) {
            if (this.isInfoEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)argA, (Object)argB);
                this.info0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void info(String format, Object ... arguments) {
            if (this.isInfoEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)arguments);
                this.info0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void info(String msg, Throwable t) {
            if (this.isInfoEnabled()) {
                this.info0(msg, t);
            }
        }

        private void info0(String msg, Throwable t) {
            this.log.info((Object)msg, t);
        }

        public boolean isWarnEnabled() {
            return this.log.isEnabled(Logger.Level.WARN);
        }

        public void warn(String msg) {
            if (this.isWarnEnabled()) {
                this.log.warn((Object)msg);
            }
        }

        public void warn(String format, Object arg) {
            if (this.isWarnEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
                this.warn0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void warn(String format, Object ... arguments) {
            if (this.isWarnEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)arguments);
                this.warn0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void warn(String format, Object argA, Object argB) {
            if (this.isWarnEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)argA, (Object)argB);
                this.warn0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void warn(String msg, Throwable t) {
            if (this.isWarnEnabled()) {
                this.warn0(msg, t);
            }
        }

        private void warn0(String msg, Throwable t) {
            this.log.warn((Object)msg, t);
        }

        public boolean isErrorEnabled() {
            return this.log.isEnabled(Logger.Level.ERROR);
        }

        public void error(String msg) {
            if (this.isErrorEnabled()) {
                this.log.error((Object)msg);
            }
        }

        public void error(String format, Object arg) {
            if (this.isErrorEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
                this.error0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void error(String format, Object argA, Object argB) {
            if (this.isErrorEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)argA, (Object)argB);
                this.error0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void error(String format, Object ... arguments) {
            if (this.isErrorEnabled()) {
                FormattingTuple ft = MessageFormatter.format((String)format, (Object)arguments);
                this.error0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void error(String msg, Throwable t) {
            if (this.isErrorEnabled()) {
                this.error0(msg, t);
            }
        }

        private void error0(String msg, Throwable t) {
            this.log.error((Object)msg, t);
        }
    }
}

