/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script from ./include/libopencm3/sam/d/irq.json
 */

#ifndef LIBOPENCM3_SAMD_NVIC_H
#define LIBOPENCM3_SAMD_NVIC_H

#include <libopencm3/cm3/nvic.h>

/** @defgroup CM3_nvic_defines_irqs User interrupts for Atmel SAMD series
    @ingroup CM3_nvic_defines

    @{*/

#define NVIC_PM_IRQ 0
#define NVIC_SYSCTRL_IRQ 1
#define NVIC_WDT_IRQ 2
#define NVIC_RTC_IRQ 3
#define NVIC_EIC_IRQ 4
#define NVIC_NVMCTRL_IRQ 5
#define NVIC_DMAC_IRQ 6
#define NVIC_RESERVED1_IRQ 7
#define NVIC_EVSYS_IRQ 8
#define NVIC_SERCOM0_IRQ 9
#define NVIC_SERCOM1_IRQ 10
#define NVIC_SERCOM2_IRQ 11
#define NVIC_TCC0_IRQ 12
#define NVIC_TC1_IRQ 13
#define NVIC_TC2_IRQ 14
#define NVIC_ADC_IRQ 15
#define NVIC_AC_IRQ 16
#define NVIC_DAC_IRQ 17
#define NVIC_PTC_IRQ 18

#define NVIC_IRQ_COUNT 19

/**@}*/

/** @defgroup CM3_nvic_isrprototypes_SAMD User interrupt service routines (ISR) prototypes for Atmel SAMD series
    @ingroup CM3_nvic_isrprototypes

    @{*/

BEGIN_DECLS

void pm_isr(void);
void sysctrl_isr(void);
void wdt_isr(void);
void rtc_isr(void);
void eic_isr(void);
void nvmctrl_isr(void);
void dmac_isr(void);
void reserved1_isr(void);
void evsys_isr(void);
void sercom0_isr(void);
void sercom1_isr(void);
void sercom2_isr(void);
void tcc0_isr(void);
void tc1_isr(void);
void tc2_isr(void);
void adc_isr(void);
void ac_isr(void);
void dac_isr(void);
void ptc_isr(void);

END_DECLS

/**@}*/

#endif /* LIBOPENCM3_SAMD_NVIC_H */
