// Licence: GPLv3 & GPLv2 (dual licensed)
// Original source: https://github.com/Ladsgroup/CheckUserHelper
'use strict';

/**
 * Adds a button underneath the summary table that when
 * pressed adds the table in a wikitext format to the
 * clipboard of the user.
 *
 * @param {string} copyText The wikitext table to copied (generated by createTableText.js)
 */
function addCopyElement( copyText ) {
	const copyTextLayout = new mw.widgets.CopyTextLayout( {
		align: 'top',
		copyText: copyText,
		successMessage: mw.message( 'checkuser-helper-copy-success' ),
		multiline: true,
		failMessage: mw.message( 'checkuser-helper-copy-failed' )
	} );
	copyTextLayout.$element.addClass( 'mw-checkuser-helper-copy-text-layout' );
	$( '.mw-checkuser-helper-table' ).after( copyTextLayout.$element );
}

module.exports = addCopyElement;
