/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.Connection;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.DataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.DriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;

public abstract class ConnectionConnectionPool
extends JDBCConnectionPool {
    static final String CLASS_NAME = ConnectionConnectionPool.class.getName();

    public ConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter, diagnosticsCollector);
        if (!(connectionFactoryAdapter instanceof DataSourceConnectionFactoryAdapter) && !(connectionFactoryAdapter instanceof DriverConnectionFactoryAdapter)) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(103);
        }
    }

    public ConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        this(connectionFactoryAdapter, (Diagnosable)DiagnosticsCollectorImpl.getCommon());
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public Connection getConnection(JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRetrievalInfo;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionConnectionPool", "getConnection", "entering args ({0})", null, null, jDBCConnectionRetrievalInfo);
            Connection conn = (Connection)this.borrowConnection((ConnectionRetrievalInfo)connectionRetrievalInfo).getPhysicalConnection();
            this.trace(Level.FINEST, CLASS_NAME, "getConnection", "connection borrowed succesfully", null, null, new Object[0]);
            Connection connection = conn;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionConnectionPool", "getConnection", "returning {0}", null, null, connection);
            return connection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionConnectionPool", "getConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public boolean returnConnection(Connection connection) throws UniversalConnectionPoolException {
        try {
            void connection2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionConnectionPool", "returnConnection", "entering args ({0})", null, null, connection);
            boolean res = this.returnUsedPhysicalConnection(connection2);
            if (res) {
                this.trace(Level.FINEST, CLASS_NAME, "returnConnection", "connection returned succesfully", null, null, new Object[0]);
            } else {
                this.trace(Level.WARNING, CLASS_NAME, "returnConnection", "failed to return connection", null, null, new Object[0]);
            }
            boolean bl = res;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionConnectionPool", "returnConnection", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionConnectionPool", "returnConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }
}

