/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.io.InputStreamFactory;
import org.directwebremoting.util.CopyUtils;

public class FormField {
    private final String string;
    private final long fileSize;
    private final String name;
    private final String mimeType;
    private final InputStreamFactory inputStreamFactory;
    private static final Log log = LogFactory.getLog(FormField.class);

    public FormField(String string) {
        this.string = string;
        this.name = null;
        this.mimeType = null;
        this.inputStreamFactory = null;
        this.fileSize = -1L;
    }

    public FormField(String name, String mimeType, long fileSize, InputStreamFactory inFactory) {
        this.string = null;
        this.name = name;
        this.mimeType = mimeType;
        this.fileSize = fileSize;
        this.inputStreamFactory = inFactory;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getFileSize() {
        if (this.string != null) {
            return this.string.length();
        }
        return this.fileSize;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStreamFactory == null) {
            throw new UnsupportedOperationException("Can't getInputStream() from a string FormField");
        }
        return this.inputStreamFactory.getInputStream();
    }

    public String getName() {
        if (this.name == null) {
            throw new UnsupportedOperationException("Can't getName() from a string FormField");
        }
        return this.name;
    }

    public String getString() {
        if (this.string == null) {
            try {
                StringWriter buffer = new StringWriter();
                CopyUtils.copy(this.inputStreamFactory.getInputStream(), (Writer)buffer);
                return buffer.toString();
            }
            catch (IOException ex) {
                log.error((Object)"Failed to read input", (Throwable)ex);
                return null;
            }
        }
        return this.string;
    }

    public boolean isFile() {
        return this.inputStreamFactory != null;
    }

    public String toString() {
        if (this.string == null) {
            return "FormField:File:" + this.name;
        }
        return "FormField:String:" + this.string;
    }

    public int hashCode() {
        if (this.string == null) {
            return super.hashCode();
        }
        return this.string.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FormField that = (FormField)obj;
        if (this.string == null) {
            return super.equals(that);
        }
        return this.string.equals(that.string);
    }
}

