/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.postgresql.core.PGStream;
import org.postgresql.core.v3.ChannelBindingOption;
import org.postgresql.shaded.com.ongres.scram.client.ScramClient;
import org.postgresql.shaded.com.ongres.scram.common.ClientFinalMessage;
import org.postgresql.shaded.com.ongres.scram.common.ClientFirstMessage;
import org.postgresql.shaded.com.ongres.scram.common.StringPreparation;
import org.postgresql.shaded.com.ongres.scram.common.exception.ScramException;
import org.postgresql.shaded.com.ongres.scram.common.util.TlsServerEndpoint;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

final class ScramAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(ScramAuthenticator.class.getName());
    private final PGStream pgStream;
    private final ScramClient scramClient;

    ScramAuthenticator(char[] password, PGStream pgStream, Properties info) throws PSQLException {
        this.pgStream = pgStream;
        this.scramClient = ScramAuthenticator.initializeScramClient(password, pgStream, info);
    }

    private static ScramClient initializeScramClient(char[] password, PGStream stream, Properties info) throws PSQLException {
        try {
            ChannelBindingOption channelBinding = ChannelBindingOption.of(info);
            LOGGER.log(Level.FINEST, "channelBinding( {0} )", (Object)channelBinding);
            byte[] cbindData = ScramAuthenticator.getChannelBindingData(stream, channelBinding);
            List<String> advertisedMechanisms = ScramAuthenticator.advertisedMechanisms(stream, channelBinding);
            ScramClient client = ScramClient.builder().advertisedMechanisms(advertisedMechanisms).username("*").password(password).channelBinding("tls-server-end-point", cbindData).stringPreparation(StringPreparation.POSTGRESQL_PREPARATION).build();
            LOGGER.log(Level.FINEST, () -> " Using SCRAM mechanism: " + client.getScramMechanism().getName());
            return client;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new PSQLException(GT.tr("Invalid SCRAM client initialization", e), PSQLState.CONNECTION_REJECTED);
        }
    }

    private static List<String> advertisedMechanisms(PGStream stream, ChannelBindingOption channelBinding) throws PSQLException, IOException {
        ArrayList<String> mechanisms = new ArrayList<String>();
        do {
            mechanisms.add(stream.receiveString());
        } while (stream.peekChar() != 0);
        int c = stream.receiveChar();
        assert (c == 0);
        if (mechanisms.isEmpty()) {
            throw new PSQLException(GT.tr("Received AuthenticationSASL message with 0 mechanisms!", new Object[0]), PSQLState.CONNECTION_REJECTED);
        }
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASL( {0} )", mechanisms);
        if (channelBinding == ChannelBindingOption.REQUIRE && !mechanisms.stream().anyMatch(m -> m.endsWith("-PLUS"))) {
            throw new PSQLException(GT.tr("Channel Binding is required, but server did not offer an authentication method that supports channel binding", new Object[0]), PSQLState.CONNECTION_REJECTED);
        }
        return mechanisms;
    }

    private static byte[] getChannelBindingData(PGStream stream, ChannelBindingOption channelBinding) throws PSQLException {
        block7: {
            if (channelBinding == ChannelBindingOption.DISABLE) {
                return new byte[0];
            }
            Socket socket = stream.getSocket();
            if (socket instanceof SSLSocket) {
                SSLSession session = ((SSLSocket)socket).getSession();
                try {
                    Certificate peerCert;
                    Certificate[] certificates = session.getPeerCertificates();
                    if (certificates != null && certificates.length > 0 && (peerCert = certificates[0]) instanceof X509Certificate) {
                        X509Certificate cert = (X509Certificate)peerCert;
                        return TlsServerEndpoint.getChannelBindingData(cert);
                    }
                    break block7;
                }
                catch (CertificateEncodingException | SSLPeerUnverifiedException e) {
                    LOGGER.log(Level.FINEST, "Error extracting channel binding data", e);
                    if (channelBinding == ChannelBindingOption.REQUIRE) {
                        throw new PSQLException(GT.tr("Channel Binding is required, but could not extract channel binding data from SSL session", new Object[0]), PSQLState.CONNECTION_REJECTED);
                    }
                    break block7;
                }
            }
            if (channelBinding == ChannelBindingOption.REQUIRE) {
                throw new PSQLException(GT.tr("Channel Binding is required, but SSL is not in use", new Object[0]), PSQLState.CONNECTION_REJECTED);
            }
        }
        return new byte[0];
    }

    void handleAuthenticationSASL() throws IOException {
        ClientFirstMessage clientFirstMessage = this.scramClient.clientFirstMessage();
        LOGGER.log(Level.FINEST, " FE=> SASLInitialResponse( {0} )", clientFirstMessage);
        String scramMechanismName = this.scramClient.getScramMechanism().getName();
        byte[] scramMechanismNameBytes = scramMechanismName.getBytes(StandardCharsets.UTF_8);
        byte[] clientFirstMessageBytes = clientFirstMessage.toString().getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(scramMechanismNameBytes.length + 1 + 4 + clientFirstMessageBytes.length, pgStream -> {
            pgStream.send(scramMechanismNameBytes);
            pgStream.sendChar(0);
            pgStream.sendInteger4(clientFirstMessageBytes.length);
            pgStream.send(clientFirstMessageBytes);
        });
    }

    void handleAuthenticationSASLContinue(int length) throws IOException, PSQLException {
        String receivedServerFirstMessage = this.pgStream.receiveString(length);
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue( {0} )", receivedServerFirstMessage);
        try {
            this.scramClient.serverFirstMessage(receivedServerFirstMessage);
        }
        catch (IllegalArgumentException | IllegalStateException | ScramException e) {
            throw new PSQLException(GT.tr("SCRAM authentication failed: {0}", e.getMessage()), PSQLState.CONNECTION_REJECTED, (Throwable)e);
        }
        ClientFinalMessage clientFinalMessage = this.scramClient.clientFinalMessage();
        LOGGER.log(Level.FINEST, " FE=> SASLResponse( {0} )", clientFinalMessage);
        byte[] clientFinalMessageBytes = clientFinalMessage.toString().getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(clientFinalMessageBytes.length, pgStream -> pgStream.send(clientFinalMessageBytes));
    }

    void handleAuthenticationSASLFinal(int length) throws IOException, PSQLException {
        String serverFinalMessage = this.pgStream.receiveString(length);
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLFinal( {0} )", serverFinalMessage);
        try {
            this.scramClient.serverFinalMessage(serverFinalMessage);
        }
        catch (IllegalArgumentException | IllegalStateException | ScramException e) {
            throw new PSQLException(GT.tr("SCRAM authentication failed: {0}", e.getMessage()), PSQLState.CONNECTION_REJECTED, (Throwable)e);
        }
    }

    private void sendAuthenticationMessage(int bodyLength, BodySender bodySender) throws IOException {
        this.pgStream.sendChar(112);
        this.pgStream.sendInteger4(4 + bodyLength);
        bodySender.sendBody(this.pgStream);
        this.pgStream.flush();
    }

    private static interface BodySender {
        public void sendBody(PGStream var1) throws IOException;
    }
}

