/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.util.Utils;

public final class DigestInfo
implements Externalizable,
ASN1Object {
    private AlgorithmIdentifier a;
    private byte[] b;
    private ASN1Sequence c = null;

    public DigestInfo() {
    }

    public DigestInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.a = algorithmIdentifier;
        this.b = byArray;
    }

    public DigestInfo(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public AlgorithmIdentifier getDigestAlgID() {
        return this.a;
    }

    public byte[] getDigest() {
        return this.b;
    }

    public boolean equals(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        return algorithmIdentifier.equals(this.a) && Utils.areEqual(byArray, this.b);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DigestInfo)) {
            return false;
        }
        DigestInfo digestInfo = (DigestInfo)object;
        return this.equals(digestInfo.a, digestInfo.b);
    }

    public String toString() {
        return this.a + ": " + Utils.toHexString(this.b);
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.a = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.b = ASN1OctetString.a(aSN1SequenceInputStream);
        aSN1SequenceInputStream.b();
        this.a();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }

    @Override
    public int length() {
        return this.b().length();
    }

    private void a() {
        this.c = null;
    }

    private ASN1Sequence b() {
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(this.a);
            aSN1Sequence.a(new ASN1OctetString(this.b));
            this.c = aSN1Sequence;
        }
        return this.c;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

