/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import com.rsa.jsafe.crypto.CryptoJVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.TimeZone;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.TransitionMode;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.textui.OracleCRLTextUI;
import oracle.security.pki.textui.OracleCertTextUI;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.textui.OracleSecretStoreTextUI;
import oracle.security.pki.textui.OracleWalletTextUI;
import oracle.security.pki.util.OIDManager;
import oracle.security.pki.util.Utils;

public class OraclePKITextUI {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    static String b = "Syntax : \n[-option [value]]     : mandatory, for example [-wallet [wallet]] \n[-option <value>]     : optional, but when option is used its value is mandatory. \n<option>              : optional, for example <-summary>, <-complete> \n[option1] | [option2] : option1 'or' option2\n";

    public static void main(String[] stringArray) {
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(new int[]{2, 5, 4, 9});
        ASN1ObjectID aSN1ObjectID2 = new ASN1ObjectID(new int[]{2, 5, 4, 12});
        ASN1ObjectID aSN1ObjectID3 = new ASN1ObjectID(new int[]{2, 5, 4, 5});
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-nologo") && !stringArray[i].equals("-use_jce") && !stringArray[i].equals("-jsafe") && !stringArray[i].equals("-use_jce_only") && !stringArray[i].equals("-print_lib_info") && !stringArray[i].equals("-fips140_mode")) continue;
            if (stringArray[i].equals("-nologo")) {
                bl = true;
            } else if (stringArray[i].equals("-print_lib_info")) {
                bl2 = true;
            } else if (!stringArray[i].equals("-use_jce") && !stringArray[i].equals("-use_jce_only")) {
                if (stringArray[i].equals("-jsafe")) {
                    try {
                        JCEUtil.registerJsafeJCE();
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        System.out.println("Unable to register Crypto-J JsafeJCE provider");
                        n = 1;
                        System.exit(n);
                    }
                } else if (stringArray[i].equals("-fips140_mode")) {
                    TransitionMode.enableFIPS140Mode();
                }
            }
            int n2 = stringArray.length - (i + 1);
            String[] stringArray2 = new String[stringArray.length - 1];
            if (stringArray.length > 1) {
                System.arraycopy(stringArray, 0, stringArray2, 0, i);
                System.arraycopy(stringArray, i + 1, stringArray2, i, n2);
            }
            stringArray = stringArray2;
            --i;
        }
        if (!TransitionMode.isFIPS140ModeEnabled() && OraclePKITextUI.a()) {
            TransitionMode.enableFIPS140Mode();
        }
        if (!bl) {
            System.out.println(OraclePKIGenFunc.copyrightVersionBanner("Oracle PKI Tool"));
            System.out.println();
        }
        if (TransitionMode.isFIPS140ModeEnabled()) {
            try {
                Provider provider = JCEUtil.getJCEProvider();
                if (bl2) {
                    System.out.println("FIPS module is enabled.");
                    System.out.println("Crypto services provider: " + provider);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                System.out.println("Unable to get FIPS 140 cryptographic module: " + generalSecurityException.getMessage());
                n = 1;
                System.exit(n);
            }
        } else if (bl2) {
            System.out.println("FIPS module is not enabled.");
            System.out.println("Crypto services provider: " + Security.getProviders()[0]);
        }
        if (stringArray.length == 0) {
            System.out.println("orapki [crl|wallet|cert|secretstore|help] <-nologo> <-jsafe> <-use_jce> <-use_jce_only> <-fips140_mode>");
            a.getString("PKI_USE_STRING");
            n = 1;
            System.exit(n);
        }
        try {
            OIDManager.getOIDManager().setAttributeTypeName("STREET_ADDR", new ASN1ObjectID(Utils.toStream(aSN1ObjectID)));
            OIDManager.getOIDManager().setAttributeTypeName("TITLE", new ASN1ObjectID(Utils.toStream(aSN1ObjectID2)));
            OIDManager.getOIDManager().setAttributeTypeName("SERIAL_NUM", new ASN1ObjectID(Utils.toStream(aSN1ObjectID3)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("Failed to initialize");
            n = 1;
            System.exit(n);
        }
        TimeZone timeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        if (stringArray[0].equals("help")) {
            System.out.println("orapki [crl|wallet|cert|secretstore|help] <-nologo> <-jsafe> <-use_jce> <-use_jce_only> <-fips140_mode>");
            System.out.println(b);
        } else if (stringArray[0].equals("crl")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            n = OracleCRLTextUI.command(stringArray3);
        } else if (stringArray[0].equals("wallet")) {
            String[] stringArray4 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray4, 0, stringArray4.length);
            n = OracleWalletTextUI.command(stringArray4);
        } else if (stringArray[0].equals("cert")) {
            String[] stringArray5 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray5, 0, stringArray5.length);
            n = OracleCertTextUI.command(stringArray5);
        } else if (stringArray[0].equals("secretstore")) {
            String[] stringArray6 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray6, 0, stringArray6.length);
            OracleSecretStoreTextUI.command(stringArray6);
        } else if (stringArray[0].equals("cryptoj_version")) {
            System.out.println("Crypto-J version is " + CryptoJVersion.getProductID());
        } else {
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println("orapki [crl|wallet|cert|secretstore|help] <-nologo> <-jsafe> <-use_jce> <-use_jce_only> <-fips140_mode>");
            n = -1;
        }
        TimeZone.setDefault(timeZone);
        System.exit(n);
    }

    private static boolean a() {
        String string = System.getenv("FIPS_HOME");
        String string2 = System.getProperty("os.name");
        if (string == null) {
            string = System.getenv("ORACLE_HOME");
            if (string == null) {
                return false;
            }
            string = string2.compareTo("Windows") == 0 ? string + "\\ldap\\admin\\fips.ora" : string + "/ldap/admin/fips.ora";
        } else {
            string = string2.compareTo("Windows") == 0 ? string + "\\fips.ora" : string + "/fips.ora";
        }
        File file = new File(string);
        if (!file.exists() || file.length() == 0L) {
            return false;
        }
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        while (scanner.hasNextLine()) {
            String string3 = scanner.nextLine();
            String[] stringArray = string3.split("=");
            if (stringArray.length != 2 || !stringArray[0].equals("FIPS_140")) continue;
            scanner.close();
            return stringArray[1].equals("TRUE");
        }
        scanner.close();
        return false;
    }
}

