"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPPLDocumentationLink = void 0;
/**
 * Get appropriate documentation link based on PPL error message
 */
const getPPLDocumentationLink = (errorMessage) => {
    const message = errorMessage.toLowerCase();
    // General PPL documentation
    return {
        title: 'PPL Documentation',
        url: 'https://opensearch.org/docs/latest/search-plugins/ppl/index/',
    };
};
exports.getPPLDocumentationLink = getPPLDocumentationLink;
//# sourceMappingURL=ppl_documentation.js.map