"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderXYChartCanvas2d = void 0;
var color_library_wrappers_1 = require("../../../../common/color_library_wrappers");
var canvas_1 = require("../../../../renderers/canvas");
var annotations_1 = require("./annotations");
var areas_1 = require("./areas");
var bars_1 = require("./bars");
var bubbles_1 = require("./bubbles");
var grids_1 = require("./grids");
var lines_1 = require("./lines");
var panels_1 = require("./panels/panels");
var debug_1 = require("./utils/debug");
var bar_1 = require("./values/bar");
function renderXYChartCanvas2d(ctx, dpr, clippings, props) {
    var imgCanvas = document.createElement('canvas');
    canvas_1.withContext(ctx, function (ctx) {
        ctx.scale(dpr, dpr);
        var renderingArea = props.renderingArea, chartTransform = props.chartTransform, rotation = props.rotation, geometries = props.geometries, geometriesIndex = props.geometriesIndex, _a = props.theme, sharedAxesStyle = _a.axes, sharedStyle = _a.sharedStyle, barSeriesStyle = _a.barSeriesStyle, highlightedLegendItem = props.highlightedLegendItem, annotationDimensions = props.annotationDimensions, annotationSpecs = props.annotationSpecs, perPanelAxisGeoms = props.perPanelAxisGeoms, perPanelGridLines = props.perPanelGridLines, axesSpecs = props.axesSpecs, axesStyles = props.axesStyles, debug = props.debug, panelGeoms = props.panelGeoms;
        var transform = {
            x: renderingArea.left + chartTransform.x,
            y: renderingArea.top + chartTransform.y,
        };
        canvas_1.renderLayers(ctx, [
            function (ctx) { return canvas_1.clearCanvas(ctx, 200000, 200000); },
            function (ctx) {
                if (debug) {
                    panels_1.renderGridPanels(ctx, transform, panelGeoms);
                }
            },
            function (ctx) {
                grids_1.renderGrids(ctx, {
                    axesSpecs: axesSpecs,
                    renderingArea: renderingArea,
                    perPanelGridLines: perPanelGridLines,
                    axesStyles: axesStyles,
                    sharedAxesStyle: sharedAxesStyle,
                });
            },
            function (ctx) {
                panels_1.renderPanelSubstrates(ctx, {
                    axesSpecs: axesSpecs,
                    perPanelAxisGeoms: perPanelAxisGeoms,
                    renderingArea: renderingArea,
                    debug: debug,
                    axesStyles: axesStyles,
                    sharedAxesStyle: sharedAxesStyle,
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    annotations_1.renderAnnotations(ctx, {
                        rotation: rotation,
                        renderingArea: renderingArea,
                        annotationDimensions: annotationDimensions,
                        annotationSpecs: annotationSpecs,
                    }, true);
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    bars_1.renderBars(ctx, imgCanvas, geometries.bars, sharedStyle, clippings, renderingArea, highlightedLegendItem, rotation);
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    areas_1.renderAreas(ctx, imgCanvas, {
                        areas: geometries.areas,
                        clippings: clippings,
                        renderingArea: renderingArea,
                        rotation: rotation,
                        highlightedLegendItem: highlightedLegendItem,
                        sharedStyle: sharedStyle,
                    });
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    lines_1.renderLines(ctx, {
                        lines: geometries.lines,
                        clippings: clippings,
                        renderingArea: renderingArea,
                        rotation: rotation,
                        highlightedLegendItem: highlightedLegendItem,
                        sharedStyle: sharedStyle,
                    });
                });
            },
            function (ctx) {
                bubbles_1.renderBubbles(ctx, {
                    bubbles: geometries.bubbles,
                    clippings: clippings,
                    highlightedLegendItem: highlightedLegendItem,
                    sharedStyle: sharedStyle,
                    rotation: rotation,
                    renderingArea: renderingArea,
                });
            },
            function (ctx) {
                geometries.bars.forEach(function (_a) {
                    var bars = _a.value, panel = _a.panel;
                    canvas_1.withContext(ctx, function (ctx) {
                        bar_1.renderBarValues(ctx, {
                            bars: bars,
                            panel: panel,
                            renderingArea: renderingArea,
                            rotation: rotation,
                            debug: debug,
                            barSeriesStyle: barSeriesStyle,
                        });
                    });
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    annotations_1.renderAnnotations(ctx, {
                        annotationDimensions: annotationDimensions,
                        annotationSpecs: annotationSpecs,
                        rotation: rotation,
                        renderingArea: renderingArea,
                    }, false);
                });
            },
            function (ctx) {
                if (!debug) {
                    return;
                }
                canvas_1.withContext(ctx, function (ctx) {
                    var left = renderingArea.left, top = renderingArea.top, width = renderingArea.width, height = renderingArea.height;
                    debug_1.renderDebugRect(ctx, {
                        x: left,
                        y: top,
                        width: width,
                        height: height,
                    }, {
                        color: color_library_wrappers_1.stringToRGB('transparent'),
                    }, {
                        color: color_library_wrappers_1.stringToRGB('red'),
                        width: 4,
                        dash: [4, 4],
                    });
                    var triangulation = geometriesIndex.triangulation([0, 0, width, height]);
                    if (triangulation) {
                        ctx.beginPath();
                        ctx.translate(left, top);
                        ctx.setLineDash([5, 5]);
                        triangulation.render(ctx);
                        ctx.lineWidth = 1;
                        ctx.strokeStyle = 'blue';
                        ctx.stroke();
                    }
                });
            },
        ]);
    });
}
exports.renderXYChartCanvas2d = renderXYChartCanvas2d;
//# sourceMappingURL=renderers.js.map