var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/misc/BitSet.ts
var BitSet_exports = {};
__export(BitSet_exports, {
  BitSet: () => BitSet
});
module.exports = __toCommonJS(BitSet_exports);
var BitSet = class {
  static {
    __name(this, "BitSet");
  }
  data;
  /**
   * Creates a new bit set. All bits are initially `false`.
   *
   * @param data Optional initial data.
   */
  constructor(data) {
    if (data) {
      this.data = new Uint32Array(data.map((value) => {
        return value >>> 0;
      }));
    } else {
      this.data = new Uint32Array(1);
    }
  }
  /**
   * @returns an iterator over all set bits.
   */
  [Symbol.iterator]() {
    const length = this.data.length;
    let currentIndex = 0;
    let currentWord = this.data[currentIndex];
    const words = this.data;
    return {
      [Symbol.iterator]() {
        return this;
      },
      next: /* @__PURE__ */ __name(() => {
        while (currentIndex < length) {
          if (currentWord !== 0) {
            const t = currentWord & -currentWord;
            const value = (currentIndex << 5) + this.bitCount(t - 1);
            currentWord ^= t;
            return { done: false, value };
          } else {
            currentIndex++;
            if (currentIndex < length) {
              currentWord = words[currentIndex];
            }
          }
        }
        return { done: true, value: void 0 };
      }, "next")
    };
  }
  /**
   * Sets a single bit or all of the bits in this `BitSet` to `false`.
   *
   * @param index the index of the bit to be cleared, or undefined to clear all bits.
   */
  clear(index) {
    if (index === void 0) {
      this.data = new Uint32Array();
    } else {
      this.resize(index);
      this.data[index >>> 5] &= ~(1 << index);
    }
  }
  /**
   * Performs a logical **OR** of this bit set with the bit set argument. This bit set is modified so that a bit in it
   * has the value `true` if and only if it either already had the value `true` or the corresponding bit in the bit
   * set argument has the value `true`.
   *
   * @param set the bit set to be ORed with.
   */
  or(set) {
    const minCount = Math.min(this.data.length, set.data.length);
    for (let k = 0; k < minCount; ++k) {
      this.data[k] |= set.data[k];
    }
    if (this.data.length < set.data.length) {
      this.resize((set.data.length << 5) - 1);
      const c = set.data.length;
      for (let k = minCount; k < c; ++k) {
        this.data[k] = set.data[k];
      }
    }
  }
  /**
   * Returns the value of the bit with the specified index. The value is `true` if the bit with the index `bitIndex`
   * is currently set in this `BitSet`; otherwise, the result is `false`.
   *
   * @param index the bit index
   *
   * @returns the value of the bit with the specified index.
   */
  get(index) {
    if (index < 0) {
      throw new RangeError("index cannot be negative");
    }
    const slot = index >>> 5;
    if (slot >= this.data.length) {
      return false;
    }
    return (this.data[slot] & 1 << index % 32) !== 0;
  }
  /**
   * @returns the number of set bits.
   */
  get length() {
    let result = 0;
    const c = this.data.length;
    const w = this.data;
    for (let i = 0; i < c; i++) {
      result += this.bitCount(w[i]);
    }
    return result;
  }
  /**
   * @returns an array with indices of set bits.
   */
  values() {
    const result = new Array(this.length);
    let pos = 0;
    const length = this.data.length;
    for (let k = 0; k < length; ++k) {
      let w = this.data[k];
      while (w !== 0) {
        const t = w & -w;
        result[pos++] = (k << 5) + this.bitCount(t - 1);
        w ^= t;
      }
    }
    return result;
  }
  /**
   * @returns the index of the first bit that is set to `true` that occurs on or after the specified starting index.
   * If no such bit exists then undefined is returned.
   *
   * @param fromIndex the index to start checking from (inclusive)
   */
  nextSetBit(fromIndex) {
    if (fromIndex < 0) {
      throw new RangeError("index cannot be negative");
    }
    for (const index of this) {
      if (index >= fromIndex) {
        return index;
      }
    }
    return void 0;
  }
  /**
   * Sets the bit at the specified index to `true`.
   *
   * @param index a bit index
   */
  set(index) {
    if (index < 0) {
      throw new RangeError("index cannot be negative");
    }
    this.resize(index);
    this.data[index >>> 5] |= 1 << index % 32;
  }
  /**
   * @returns a string representation of this bit set.
   */
  toString() {
    return "{" + this.values().join(", ") + "}";
  }
  resize(index) {
    const count = index + 32 >>> 5;
    if (count <= this.data.length) {
      return;
    }
    const data = new Uint32Array(count);
    data.set(this.data);
    data.fill(0, this.data.length);
    this.data = data;
  }
  bitCount(v) {
    v = v - (v >> 1 & 1431655765);
    v = (v & 858993459) + (v >> 2 & 858993459);
    v = v + (v >> 4) & 252645135;
    v = v + (v >> 8);
    v = v + (v >> 16);
    return v & 63;
  }
};
