/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.Encoder;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.MethodResolver;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.Mode;

public abstract class AbstractMethodResolver
implements MethodResolver {
    protected CompressionLevel resolveCompressionLevelFromMethodContext(KNNMethodContext resolvedKnnMethodContext, KNNMethodConfigContext knnMethodConfigContext, Map<String, Encoder> encoderMap) {
        if (!this.isEncoderSpecified(resolvedKnnMethodContext)) {
            return CompressionLevel.x1;
        }
        Encoder encoder = encoderMap.get(this.getEncoderName(resolvedKnnMethodContext));
        if (encoder == null) {
            return CompressionLevel.NOT_CONFIGURED;
        }
        return encoder.calculateCompressionLevel(this.getEncoderComponentContext(resolvedKnnMethodContext), knnMethodConfigContext);
    }

    protected void resolveMethodParams(MethodComponentContext methodComponentContext, KNNMethodConfigContext knnMethodConfigContext, MethodComponent methodComponent) {
        Map<String, Object> resolvedParams = MethodComponent.getParameterMapWithDefaultsAdded(methodComponentContext, methodComponent, knnMethodConfigContext);
        methodComponentContext.getParameters().putAll(resolvedParams);
    }

    protected KNNMethodContext initResolvedKNNMethodContext(KNNMethodContext originalMethodContext, KNNEngine knnEngine, SpaceType spaceType, String methodName) {
        if (originalMethodContext == null) {
            return new KNNMethodContext(knnEngine, spaceType, new MethodComponentContext(methodName, new HashMap<String, Object>()));
        }
        return new KNNMethodContext(originalMethodContext);
    }

    protected String getEncoderName(KNNMethodContext knnMethodContext) {
        if (!this.isEncoderSpecified(knnMethodContext)) {
            return null;
        }
        MethodComponentContext methodComponentContext = this.getEncoderComponentContext(knnMethodContext);
        if (methodComponentContext == null) {
            return null;
        }
        return methodComponentContext.getName();
    }

    protected MethodComponentContext getEncoderComponentContext(KNNMethodContext knnMethodContext) {
        if (!this.isEncoderSpecified(knnMethodContext)) {
            return null;
        }
        return (MethodComponentContext)knnMethodContext.getMethodComponentContext().getParameters().get("encoder");
    }

    protected boolean isEncoderSpecified(KNNMethodContext knnMethodContext) {
        return knnMethodContext != null && knnMethodContext.getMethodComponentContext().getParameters() != null && knnMethodContext.getMethodComponentContext().getParameters().containsKey("encoder");
    }

    protected boolean shouldEncoderBeResolved(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        if (this.isEncoderSpecified(knnMethodContext)) {
            return false;
        }
        if (knnMethodConfigContext.getCompressionLevel() == CompressionLevel.x1) {
            return false;
        }
        if (!CompressionLevel.isConfigured(knnMethodConfigContext.getCompressionLevel()) && Mode.ON_DISK != knnMethodConfigContext.getMode()) {
            return false;
        }
        return VectorDataType.FLOAT == knnMethodConfigContext.getVectorDataType();
    }

    protected ValidationException validateNotTrainingContext(boolean shouldRequireTraining, KNNEngine knnEngine, ValidationException validationException) {
        if (shouldRequireTraining) {
            validationException = validationException == null ? new ValidationException() : validationException;
            validationException.addValidationError(String.format(Locale.ROOT, "Cannot use \"%s\" engine from training context", knnEngine.getName()));
        }
        return validationException;
    }

    protected ValidationException validateCompressionSupported(CompressionLevel compressionLevel, Set<CompressionLevel> supportedCompressionLevels, KNNEngine knnEngine, ValidationException validationException) {
        if (CompressionLevel.isConfigured(compressionLevel) && !supportedCompressionLevels.contains((Object)compressionLevel)) {
            validationException = validationException == null ? new ValidationException() : validationException;
            validationException.addValidationError(String.format(Locale.ROOT, "\"%s\" does not support \"%s\" compression", knnEngine.getName(), compressionLevel.getName()));
        }
        return validationException;
    }

    protected ValidationException validateCompressionNotx1WhenOnDisk(KNNMethodConfigContext knnMethodConfigContext, ValidationException validationException) {
        if (knnMethodConfigContext.getCompressionLevel() == CompressionLevel.x1 && knnMethodConfigContext.getMode() == Mode.ON_DISK) {
            validationException = validationException == null ? new ValidationException() : validationException;
            validationException.addValidationError(String.format(Locale.ROOT, "Cannot specify \"x1\" compression level when using \"%s\" mode", Mode.ON_DISK.getName()));
        }
        return validationException;
    }

    protected void validateCompressionConflicts(CompressionLevel originalCompressionLevel, CompressionLevel resolvedCompressionLevel) {
        if (CompressionLevel.isConfigured(originalCompressionLevel) && CompressionLevel.isConfigured(resolvedCompressionLevel) && resolvedCompressionLevel != originalCompressionLevel) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("Cannot specify an encoder that conflicts with the provided compression level");
            throw validationException;
        }
    }
}

