/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.tools.TableListing;
import org.apache.hadoop.util.Preconditions;

public class AdminHelper {
    static final int MAX_LINE_WIDTH = 80;
    static final String HELP_COMMAND_NAME = "-help";

    public static DistributedFileSystem getDFS(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        return AdminHelper.checkAndGetDFS(fs, conf);
    }

    static DistributedFileSystem getDFS(URI uri, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        return AdminHelper.checkAndGetDFS(fs, conf);
    }

    static DistributedFileSystem checkAndGetDFS(FileSystem fs, Configuration conf) throws IOException {
        if (fs instanceof ViewFileSystemOverloadScheme) {
            fs = ((ViewFileSystemOverloadScheme)fs).getRawFileSystem(new Path(FileSystem.getDefaultUri((Configuration)conf)), conf);
        }
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs.getUri() + " is not an HDFS file system. The fs class is: " + fs.getClass().getName());
        }
        return (DistributedFileSystem)fs;
    }

    static String prettifyException(Exception e) {
        if (e.getLocalizedMessage() != null) {
            return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage().split("\n")[0];
        }
        if (e.getStackTrace() != null && e.getStackTrace().length > 0) {
            return e.getClass().getSimpleName() + " at " + e.getStackTrace()[0];
        }
        return e.getClass().getSimpleName();
    }

    static TableListing getOptionDescriptionListing() {
        return new TableListing.Builder().addField("").addField("", true).wrapWidth(80).hideHeaders().build();
    }

    static Long parseTtlString(String maxTtlString) throws IOException {
        Long maxTtl = null;
        if (maxTtlString != null) {
            maxTtl = maxTtlString.equalsIgnoreCase("never") ? Long.valueOf(0x1FFFFFFFFFFFFFFFL) : Long.valueOf(DFSUtil.parseRelativeTime(maxTtlString));
        }
        return maxTtl;
    }

    static Long parseLimitString(String limitString) {
        Long limit = null;
        if (limitString != null) {
            limit = limitString.equalsIgnoreCase("unlimited") ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(Long.parseLong(limitString));
        }
        return limit;
    }

    static Command determineCommand(String commandName, Command[] commands) {
        Preconditions.checkNotNull((Object)commands);
        if (HELP_COMMAND_NAME.equals(commandName)) {
            return new HelpCommand(commands);
        }
        for (Command command : commands) {
            if (!command.getName().equals(commandName)) continue;
            return command;
        }
        return null;
    }

    static void printUsage(boolean longUsage, String toolName, Command[] commands) {
        Preconditions.checkNotNull((Object)commands);
        System.err.println("Usage: bin/hdfs " + toolName + " [COMMAND]");
        HelpCommand helpCommand = new HelpCommand(commands);
        for (Command command : commands) {
            if (longUsage) {
                System.err.print(command.getLongUsage());
                continue;
            }
            System.err.print("          " + command.getShortUsage());
        }
        System.err.print(longUsage ? helpCommand.getLongUsage() : "          " + helpCommand.getShortUsage());
        System.err.println();
    }

    static class HelpCommand
    implements Command {
        private final Command[] commands;

        public HelpCommand(Command[] commands) {
            Preconditions.checkNotNull((Object)commands, (Object)"commands cannot be null.");
            this.commands = commands;
        }

        @Override
        public String getName() {
            return AdminHelper.HELP_COMMAND_NAME;
        }

        @Override
        public String getShortUsage() {
            return "[-help <command-name>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<command-name>", "The command for which to get detailed help. If no command is specified, print detailed help for all commands"});
            return this.getShortUsage() + "\nGet detailed help about a command.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            if (args.size() == 0) {
                for (Command command : this.commands) {
                    System.err.println(command.getLongUsage());
                }
                return 1;
            }
            if (args.size() != 1) {
                System.err.println("You must give exactly one argument to -help.");
                return 1;
            }
            String commandName = args.get(0);
            Command command = AdminHelper.determineCommand("-" + commandName, this.commands);
            if (command == null) {
                System.err.print("Unknown command '" + commandName + "'.\n");
                System.err.print("Valid help command names are:\n");
                String separator = "";
                for (Command c : this.commands) {
                    System.err.print(separator + c.getName().substring(1));
                    separator = ", ";
                }
                System.err.print("\n");
                return 1;
            }
            System.err.print(command.getLongUsage());
            return 0;
        }
    }

    static interface Command {
        public String getName();

        public String getShortUsage();

        public String getLongUsage();

        public int run(Configuration var1, List<String> var2) throws IOException;
    }
}

