/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

public final class StringBuilder2 {
    private final char[] buffer;
    private int length = 0;

    public StringBuilder2(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be non-negative");
        }
        this.buffer = new char[capacity];
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int length() {
        return this.length;
    }

    public StringBuilder2 append(char c) {
        if (this.length == this.buffer.length) {
            throw new IllegalStateException("Capacity exceeded");
        }
        this.buffer[this.length++] = c;
        return this;
    }

    public StringBuilder2 append(CharSequence csq) {
        if (csq == null) {
            throw new IllegalArgumentException();
        }
        return this.append(csq, 0, csq.length());
    }

    public StringBuilder2 append(CharSequence csq, int start, int end) {
        if (csq == null) {
            throw new IllegalArgumentException();
        }
        int len = end - start;
        if (this.length + len > this.buffer.length) {
            throw new IllegalStateException("Capacity exceeded");
        }
        for (int i = start; i < end; ++i) {
            this.buffer[this.length++] = csq.charAt(i);
        }
        return this;
    }

    public StringBuilder2 append(String str) {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        int len = str.length();
        if (this.length + len > this.buffer.length) {
            throw new IllegalStateException("Capacity exceeded");
        }
        str.getChars(0, len, this.buffer, this.length);
        this.length += len;
        return this;
    }

    public StringBuilder2 append(int value) {
        return this.append(Integer.toString(value));
    }

    public StringBuilder2 clear() {
        this.length = 0;
        return this;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return this.buffer[index];
    }

    public String toString() {
        return new String(this.buffer, 0, this.length);
    }
}

