/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.solver;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.Value;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.solver.Solver;
import net.sourceforge.plantuml.project.time.Day;

public abstract class AbstractSolver
implements Solver {
    protected final Map<TaskAttribute, Value> values = new LinkedHashMap<TaskAttribute, Value>();

    @Override
    public final void setData(TaskAttribute attribute, Value value) {
        Day previousInstant;
        Value previous = this.values.remove((Object)attribute);
        if (previous != null && attribute == TaskAttribute.START && (previousInstant = (Day)previous).compareTo((Day)value) > 0) {
            value = previous;
        }
        this.values.put(attribute, value);
        if (this.values.size() > 2) {
            this.removeFirstElement();
        }
        assert (this.values.size() <= 2);
    }

    private void removeFirstElement() {
        Iterator<Map.Entry<TaskAttribute, Value>> it = this.values.entrySet().iterator();
        it.next();
        it.remove();
    }

    @Override
    public final Value getData(TaskAttribute attribute) {
        Value result = this.values.get((Object)attribute);
        if (result == null) {
            if (attribute == TaskAttribute.END) {
                return this.computeEnd();
            }
            if (attribute == TaskAttribute.START) {
                return this.computeStart();
            }
            return Load.inWinks(1);
        }
        return result;
    }

    protected abstract Value computeEnd();

    protected abstract Value computeStart();
}

