/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueImpl;
import net.sourceforge.plantuml.style.parser.StyleParser;
import net.sourceforge.plantuml.style.parser.StyleParsingException;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.LineLocationImpl;
import net.sourceforge.plantuml.utils.Log;

public final class StyleLoader {
    private static final ConcurrentMap<String, StyleBuilder> cache = new ConcurrentHashMap<String, StyleBuilder>();
    public static final int DELTA_PRIORITY_FOR_STEREOTYPE = 1000;

    private StyleLoader() {
    }

    public static StyleBuilder loadSkin(String filename) throws IOException, StyleParsingException {
        try {
            if (cache.size() >= 30) {
                cache.clear();
            }
            StyleBuilder builder = cache.computeIfAbsent(filename, key -> {
                try {
                    return StyleLoader.loadSkinSlow(key);
                }
                catch (IOException | StyleParsingException e) {
                    throw new RuntimeException(e);
                }
            });
            return builder.cloneMe();
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof StyleParsingException) {
                throw (StyleParsingException)cause;
            }
            throw ex;
        }
    }

    private static StyleBuilder loadSkinSlow(String filename) throws IOException, StyleParsingException {
        StyleBuilder styleBuilder = new StyleBuilder();
        InputStream internalIs = StyleLoader.getInputStreamForStyle(filename);
        if (internalIs == null) {
            Log.error("No .skin file seems to be available");
            throw new NoStyleAvailableException();
        }
        BlocLines lines2 = BlocLines.load(internalIs, (LineLocation)new LineLocationImpl(filename, null));
        for (Style newStyle : StyleParser.parse(lines2, styleBuilder)) {
            styleBuilder.loadInternal(newStyle.getSignature(), newStyle);
        }
        return styleBuilder;
    }

    public static InputStream getInputStreamForStyle(String filename) throws IOException {
        InputStream internalIs = null;
        SFile localFile = new SFile(filename);
        Log.info(() -> "Trying to load style " + filename);
        try {
            if (!localFile.exists()) {
                localFile = FileSystem.getInstance().getFile(filename);
            }
        }
        catch (IOException e) {
            Log.info(() -> "Cannot open file. " + e);
        }
        SFile localFile2 = localFile;
        if (localFile.exists()) {
            Log.info(() -> "File found : " + localFile2.getPrintablePath());
            internalIs = localFile.openFile();
        } else {
            Log.info(() -> "File not found : " + localFile2.getPrintablePath());
            String res = "/skin/" + filename;
            internalIs = StyleLoader.class.getResourceAsStream(res);
            if (internalIs != null) {
                Log.info(() -> "... but " + filename + " found inside the .jar");
            }
        }
        return internalIs;
    }

    public static Map<PName, Value> addPriorityForStereotype(Map<PName, Value> tmp) {
        EnumMap<PName, Value> result = new EnumMap<PName, Value>(PName.class);
        for (Map.Entry<PName, Value> ent : tmp.entrySet()) {
            result.put(ent.getKey(), ((ValueImpl)ent.getValue()).addPriority(1000));
        }
        return result;
    }
}

