/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UPolygon;

public class PentaAShape
implements UDrawable {
    private final double width;
    private final double height;
    private final Fashion context;
    private final double delta = 12.0;

    private PentaAShape(double width, double height, Fashion context) {
        this.width = width;
        this.height = height;
        this.context = context;
    }

    public static PentaAShape create(double width, double height, Fashion context) {
        return new PentaAShape(width, height, context);
    }

    @Override
    public void drawU(UGraphic ug) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(this.width - 12.0, 0.0);
        polygon.addPoint(this.width, this.height / 2.0);
        polygon.addPoint(this.width - 12.0, this.height);
        polygon.addPoint(0.0, this.height);
        this.context.withForeColor(this.context.getBackColor()).apply(ug).draw(polygon);
        UPath path = UPath.none();
        path.moveTo(0.0, 0.0);
        path.lineTo(this.width - 12.0, 0.0);
        path.lineTo(this.width, this.height / 2.0);
        path.lineTo(this.width - 12.0, this.height);
        path.lineTo(0.0, this.height);
        this.context.apply(ug).draw(path);
    }
}

