/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.internal.algorithm;

import org.eclipse.elk.alg.common.nodespacing.cellsystem.AtomicCell;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.LabelCell;
import org.eclipse.elk.alg.common.nodespacing.internal.NodeContext;
import org.eclipse.elk.alg.common.nodespacing.internal.NodeLabelLocation;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;

public final class CellSystemConfigurator {
    private CellSystemConfigurator() {
    }

    public static void configureCellSystemSizeContributions(NodeContext nodeContext) {
        if (nodeContext.sizeConstraints.isEmpty()) {
            return;
        }
        if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.PORTS)) {
            nodeContext.insidePortLabelCells.get((Object)PortSide.NORTH).setContributesToMinimumWidth(true);
            nodeContext.insidePortLabelCells.get((Object)PortSide.SOUTH).setContributesToMinimumWidth(true);
            boolean freePortPlacement = nodeContext.portConstraints != PortConstraints.FIXED_RATIO && nodeContext.portConstraints != PortConstraints.FIXED_POS;
            nodeContext.insidePortLabelCells.get((Object)PortSide.EAST).setContributesToMinimumHeight(freePortPlacement);
            nodeContext.insidePortLabelCells.get((Object)PortSide.WEST).setContributesToMinimumHeight(freePortPlacement);
            nodeContext.nodeContainerMiddleRow.setContributesToMinimumHeight(freePortPlacement);
            if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.PORT_LABELS)) {
                nodeContext.insidePortLabelCells.get((Object)PortSide.NORTH).setContributesToMinimumHeight(true);
                nodeContext.insidePortLabelCells.get((Object)PortSide.SOUTH).setContributesToMinimumHeight(true);
                nodeContext.insidePortLabelCells.get((Object)PortSide.EAST).setContributesToMinimumWidth(true);
                nodeContext.insidePortLabelCells.get((Object)PortSide.WEST).setContributesToMinimumWidth(true);
                nodeContext.nodeContainerMiddleRow.setContributesToMinimumWidth(true);
            }
        }
        if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.NODE_LABELS)) {
            nodeContext.insideNodeLabelContainer.setContributesToMinimumHeight(true);
            nodeContext.insideNodeLabelContainer.setContributesToMinimumWidth(true);
            nodeContext.nodeContainerMiddleRow.setContributesToMinimumHeight(true);
            nodeContext.nodeContainerMiddleRow.setContributesToMinimumWidth(true);
            boolean overhang = nodeContext.sizeOptions.contains((Object)SizeOptions.OUTSIDE_NODE_LABELS_OVERHANG);
            NodeLabelLocation[] nodeLabelLocationArray = NodeLabelLocation.values();
            int n = nodeLabelLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeLabelLocation location = nodeLabelLocationArray[n2];
                LabelCell labelCell = nodeContext.nodeLabelCells.get((Object)location);
                if (labelCell != null) {
                    if (location.isInsideLocation()) {
                        labelCell.setContributesToMinimumHeight(true);
                        labelCell.setContributesToMinimumWidth(true);
                    } else {
                        labelCell.setContributesToMinimumHeight(!overhang);
                        labelCell.setContributesToMinimumWidth(!overhang);
                    }
                }
                ++n2;
            }
        }
        if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.MINIMUM_SIZE) && nodeContext.sizeOptions.contains((Object)SizeOptions.MINIMUM_SIZE_ACCOUNTS_FOR_PADDING)) {
            nodeContext.nodeContainerMiddleRow.setContributesToMinimumHeight(true);
            nodeContext.nodeContainerMiddleRow.setContributesToMinimumHeight(true);
            if (!nodeContext.insideNodeLabelContainer.isContributingToMinimumHeight()) {
                nodeContext.insideNodeLabelContainer.setContributesToMinimumHeight(true);
                nodeContext.insideNodeLabelContainer.setContributesToMinimumWidth(true);
                nodeContext.insideNodeLabelContainer.setOnlyCenterCellContributesToMinimumSize(true);
            }
        }
    }

    public static void updateVerticalInsidePortLabelCellPadding(NodeContext nodeContext) {
        if (nodeContext.portConstraints == PortConstraints.FIXED_RATIO || nodeContext.portConstraints == PortConstraints.FIXED_POS) {
            return;
        }
        double topBorderOffset = nodeContext.nodeContainer.getPadding().top + nodeContext.insidePortLabelCells.get((Object)PortSide.NORTH).getMinimumHeight() + nodeContext.labelCellSpacing;
        double bottomBorderOffset = nodeContext.nodeContainer.getPadding().bottom + nodeContext.insidePortLabelCells.get((Object)PortSide.SOUTH).getMinimumHeight() + nodeContext.labelCellSpacing;
        AtomicCell eastCell = nodeContext.insidePortLabelCells.get((Object)PortSide.EAST);
        AtomicCell westCell = nodeContext.insidePortLabelCells.get((Object)PortSide.WEST);
        double topPadding = Math.max(0.0, eastCell.getPadding().top - topBorderOffset);
        topPadding = Math.max(topPadding, westCell.getPadding().top - topBorderOffset);
        double bottomPadding = Math.max(0.0, eastCell.getPadding().bottom - bottomBorderOffset);
        bottomPadding = Math.max(bottomPadding, westCell.getPadding().bottom - bottomBorderOffset);
        eastCell.getPadding().top = topPadding;
        westCell.getPadding().top = topPadding;
        eastCell.getPadding().bottom = bottomPadding;
        westCell.getPadding().bottom = bottomPadding;
    }
}

