/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.Map;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.LabelCell;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class EndLabelPostprocessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("End label post-processing", 1.0f);
        layeredGraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).filter(node -> (node.getType() == LNode.NodeType.NORMAL || node.getType() == LNode.NodeType.EXTERNAL_PORT) && node.hasProperty(InternalProperties.END_LABELS)).forEach(node -> this.processNode((LNode)node));
        monitor.done();
    }

    private void processNode(LNode node) {
        assert (node.hasProperty(InternalProperties.END_LABELS));
        Map<LPort, LabelCell> endLabelCells = node.getProperty(InternalProperties.END_LABELS);
        assert (!endLabelCells.isEmpty());
        KVector nodePos = node.getPosition();
        for (LabelCell labelCell : endLabelCells.values()) {
            ElkRectangle labelCellRect = labelCell.getCellRectangle();
            labelCellRect.move(nodePos);
            labelCell.applyLabelLayout();
        }
        node.setProperty(InternalProperties.END_LABELS, (Object)null);
    }
}

