/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

public class AbstractCell {
    public int[][] rows = new int[3][3];

    public AbstractCell() {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.rows[x][y] = 0;
            }
        }
    }

    static AbstractCell makeHorizontalLine() {
        AbstractCell result = new AbstractCell();
        result.rows[0][1] = 1;
        result.rows[1][1] = 1;
        result.rows[2][1] = 1;
        return result;
    }

    static AbstractCell makeVerticalLine() {
        AbstractCell result = new AbstractCell();
        result.rows[1][0] = 1;
        result.rows[1][1] = 1;
        result.rows[1][2] = 1;
        return result;
    }

    static AbstractCell makeCorner1() {
        AbstractCell result = new AbstractCell();
        result.rows[1][1] = 1;
        result.rows[1][2] = 1;
        result.rows[2][1] = 1;
        return result;
    }

    static AbstractCell makeCorner2() {
        AbstractCell result = new AbstractCell();
        result.rows[0][1] = 1;
        result.rows[1][1] = 1;
        result.rows[1][2] = 1;
        return result;
    }

    static AbstractCell makeCorner3() {
        AbstractCell result = new AbstractCell();
        result.rows[0][1] = 1;
        result.rows[1][1] = 1;
        result.rows[1][0] = 1;
        return result;
    }

    static AbstractCell makeCorner4() {
        AbstractCell result = new AbstractCell();
        result.rows[2][1] = 1;
        result.rows[1][1] = 1;
        result.rows[1][0] = 1;
        return result;
    }

    static AbstractCell makeT() {
        AbstractCell result = AbstractCell.makeHorizontalLine();
        result.rows[1][2] = 1;
        return result;
    }

    static AbstractCell makeInverseT() {
        AbstractCell result = AbstractCell.makeHorizontalLine();
        result.rows[1][0] = 1;
        return result;
    }

    static AbstractCell makeK() {
        AbstractCell result = AbstractCell.makeVerticalLine();
        result.rows[2][1] = 1;
        return result;
    }

    static AbstractCell makeInverseK() {
        AbstractCell result = AbstractCell.makeVerticalLine();
        result.rows[0][1] = 1;
        return result;
    }

    static AbstractCell makeCross() {
        AbstractCell result = AbstractCell.makeVerticalLine();
        result.rows[0][1] = 1;
        result.rows[2][1] = 1;
        return result;
    }

    static AbstractCell makeStar() {
        AbstractCell result = AbstractCell.makeVerticalLine();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                result.rows[x][y] = 1;
            }
        }
        return result;
    }
}

