#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-1XP3mIFBrKhCF5W3gIkUzM
key:                  postgrest-10.0.0-1XP3mIFBrKhCF5W3gIkUzM
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  a3829c33c1d370f7649983af5d76eebf
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-1XP3mIFBrKhCF5W3gIkUzM
depends:
    HTTP-4000.4.1-ICjTIL3GkJGBSmcdse9PNR
    Ranged-sets-0.5.0-DvZqLSezTWy2qNNSewwTba
    aeson-2.1.2.1-KHwyqlRT8uq4KliO3neHti
    auto-update-0.1.6-D3JW3Ad5ifM3i2jVbAnPeD base-4.17.2.1
    base64-bytestring-1.2.1.0-F6smDE5HGDf8fxaFSXDtqF
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-H8Fvgv7YDBkYcnBQIbjuM
    cassava-0.5.4.1-8iO9iOg0Y6tJVHPNzEhUWy
    configurator-pg-0.2.10-Id00DriqecqCK7FA38UQe6 containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-252Hz4PW8FtBNUU47CoDJB
    gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    hasql-1.5.0.5-18bSWORFZct6UhUJRcL0rg
    hasql-dynamic-statements-0.3.1.1-4O11aIXYYGOHMZxfnBt4jn
    hasql-notifications-0.2.0.5-KIkUTCiKSmA5eX5ZrH1fsx
    hasql-pool-0.5.2.2-7hzsBM4Mppb9gk8HYA91Dz
    hasql-transaction-1.0.1.1-1dbV4fzveGnDbgGCj0nw1t
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-FtU8gz6pIQD8uIXzLWqrj
    insert-ordered-containers-0.2.5.3-FGbpuKdXpDb2P3zwjaNTrU
    interpolatedstring-perl6-1.0.2-NYA6c9zt3LCuRSDbtvk6Z
    jose-0.10-HRaRNNn8gcTGNV48jPjtau lens-5.3.3-9P3St5wWJF5HjKYbI9rQQ
    lens-aeson-1.2.3-9q4rXl4hBDX9GKRr2Bbs2A mtl-2.2.2
    network-3.1.4.0-Fdysxcu9OH32QGRZPBFSYA
    network-uri-2.6.4.2-H8OxlLs11Qp5PfJGWOmWWd
    optparse-applicative-0.18.1.0-5hEjxtklL2LAyTbZT8Ydpk
    parsec-3.1.16.1 protolude-0.3.5-LBoGLBM77KmJYasOaoJ9TY
    regex-tdfa-1.3.2.5-BezLFEZ8z7L6k5TXRgb20N
    retry-0.9.3.1-6cLtYnbIsiDsdetsKaVcI
    scientific-0.3.8.0-FzkpGwEDtoiC1o6P6Xyy7X
    swagger2-2.8.10-2WJLz7CdkaNI84fHOVsyeg text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20.1-L9h8TvnOBH1Ihya3LZF9bU
    vault-0.3.1.5-7Xj798Xo38IKx3UTKod1fk
    vector-0.13.2.0-EKABDCAVgb42yYEtp4rYAX
    wai-3.2.4-HRHEADwk9POF0mrDAofsIw
    wai-cors-0.2.7-3wKgMN03ZunHmiw47GgsSe
    wai-extra-3.1.18-2s0XLxE0lxE5eNYMMQp8a7
    wai-logger-2.5.0-5CBgtHJOKQbF5ozuoR64My
    warp-3.4.0-9lZVZaTFnSUJgaAPY0uhZC

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

