/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import java.util.List;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.impl.GDSServerVersionException;
import org.firebirdsql.gds.ng.FbAttachment;

public interface JnaAttachment
extends FbAttachment {
    default public GDSServerVersion getClientVersion() {
        GDSServerVersion serverVersion = this.getServerVersion();
        List<String> rawVersions = serverVersion.getRawVersions();
        if (rawVersions.isEmpty()) {
            return GDSServerVersion.INVALID_VERSION;
        }
        try {
            return GDSServerVersion.parseRawVersion(rawVersions.get(rawVersions.size() - 1));
        }
        catch (GDSServerVersionException e) {
            return GDSServerVersion.INVALID_VERSION;
        }
    }
}

